/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.util;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.pinyin.bs.PinyinBs;
import com.github.houbb.pinyin.constant.enums.PinyinStyleEnum;
import com.github.houbb.pinyin.spi.IPinyinToneStyle;
import com.github.houbb.pinyin.support.style.PinyinToneStyles;
import java.util.List;

public final class PinyinHelper {
    private static final PinyinBs PINYIN_BS_DEFAULT = PinyinBs.newInstance();

    private PinyinHelper() {
    }

    public static String toPinyin(String string) {
        return PINYIN_BS_DEFAULT.toPinyin(string);
    }

    public static String toPinyin(String string, PinyinStyleEnum styleEnum) {
        return PinyinHelper.toPinyin(string, styleEnum, " ");
    }

    public static String toPinyin(String string, PinyinStyleEnum styleEnum, String connector) {
        ArgUtil.notNull((Object)connector, (String)"connector");
        if (StringUtil.isEmptyTrim((String)string)) {
            return string;
        }
        IPinyinToneStyle style = PinyinToneStyles.getTone(styleEnum);
        return PinyinBs.newInstance().style(style).connector(connector).toPinyin(string);
    }

    public static List<String> toPinyinList(char chinese) {
        return PINYIN_BS_DEFAULT.toPinyinList(chinese);
    }

    public static List<String> toPinyinList(char chinese, PinyinStyleEnum styleEnum) {
        IPinyinToneStyle pinyinTone = PinyinToneStyles.getTone(styleEnum);
        return PinyinBs.newInstance().style(pinyinTone).toPinyinList(chinese);
    }

    public static boolean hasSamePinyin(char chineseOne, char chineseTwo) {
        return PINYIN_BS_DEFAULT.hasSamePinyin(chineseOne, chineseTwo);
    }

    public static List<Integer> toneNumList(String chinese) {
        return PINYIN_BS_DEFAULT.toneNumList(chinese);
    }

    public static List<Integer> toneNumList(char chinese) {
        return PINYIN_BS_DEFAULT.toneNumList(chinese);
    }

    @Deprecated
    public static List<String> shengMuList(String chinese) {
        IPinyinToneStyle pinyinTone = PinyinToneStyles.getTone(PinyinStyleEnum.NORMAL);
        return PinyinBs.newInstance().style(pinyinTone).shengMuList(chinese);
    }

    @Deprecated
    public static List<String> yunMuList(String chinese) {
        IPinyinToneStyle pinyinTone = PinyinToneStyles.getTone(PinyinStyleEnum.NORMAL);
        return PinyinBs.newInstance().style(pinyinTone).yunMuList(chinese);
    }
}

