/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.codec;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.codec.CodecSupport;
import com.github.houbb.heaven.util.lang.StringUtil;

public final class Base64 {
    private static final char[] HEX_ARRAY;
    private static final char[] ALPHABET;
    private static final byte[] CODES;

    private Base64() {
    }

    public static String encodeToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Base64.byteToHex(b));
        }
        return sb.toString();
    }

    public static String encodeToString(String text) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        return Base64.encodeToString(text.getBytes());
    }

    public static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = ALPHABET[quad ? val & 0x3F : 64];
            out[index + 2] = ALPHABET[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = ALPHABET[(val >>= 6) & 0x3F];
            out[index] = ALPHABET[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static byte[] decode(byte[] bytes) {
        char[] chars = CodecSupport.toChars(bytes);
        return Base64.decode(chars);
    }

    public static byte[] decode(char[] data) {
        if (data == null) {
            return null;
        }
        int len = (data.length + 3) / 4 * 3;
        if (data.length > 0 && data[data.length - 1] == '=') {
            --len;
        }
        if (data.length > 1 && data[data.length - 2] == '=') {
            --len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (char aData : data) {
            byte value = CODES[aData & 0xFF];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != out.length) {
            throw new CommonRuntimeException("miscalculated data length!");
        }
        return out;
    }

    public static String decodeToString(String text) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        return new String(Base64.decode(text.toCharArray()));
    }

    public static String decodeToString(byte[] bytes) {
        String text = CodecSupport.toString(bytes);
        return Base64.decodeToString(text);
    }

    public static String encode(String text) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        byte[] bytes = CodecSupport.toBytes(text);
        char[] chars = Base64.encode(bytes);
        return CodecSupport.toString(chars);
    }

    private static String byteToHex(byte b) {
        int n = b;
        if (n < 0) {
            n += 256;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        String charOne = String.valueOf(HEX_ARRAY[d1]);
        String charTwo = String.valueOf(HEX_ARRAY[d2]);
        return charOne + charTwo;
    }

    static {
        int i;
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        CODES = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64.CODES[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64.CODES[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.CODES[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64.CODES[i] = (byte)(52 + i - 48);
        }
        Base64.CODES[43] = 62;
        Base64.CODES[47] = 63;
    }
}

