/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.mapperhelper;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

public class EntityHelper {
    private static final Map<Class<?>, EntityTable> entityTableMap = new HashMap();
    private static final Map<Class<?>, List<EntityColumn>> entityClassColumns = new HashMap();
    private static final Map<Class<?>, List<EntityColumn>> entityClassPKColumns = new HashMap();

    public static EntityTable getEntityTable(Class<?> entityClass) {
        EntityTable entityTable = entityTableMap.get(entityClass);
        if (entityTable == null) {
            EntityHelper.initEntityNameMap(entityClass);
            entityTable = entityTableMap.get(entityClass);
        }
        if (entityTable == null) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u5bf9\u5e94\u7684\u8868\u540d!");
        }
        return entityTable;
    }

    public static List<EntityColumn> getColumns(Class<?> entityClass) {
        EntityHelper.getEntityTable(entityClass);
        return entityClassColumns.get(entityClass);
    }

    public static List<EntityColumn> getPKColumns(Class<?> entityClass) {
        EntityHelper.getEntityTable(entityClass);
        return entityClassPKColumns.get(entityClass);
    }

    public static String getSelectColumns(Class<?> entityClass) {
        List<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        boolean skipAlias = Map.class.isAssignableFrom(entityClass);
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn());
            if (!skipAlias && !entityColumn.getColumn().equalsIgnoreCase(entityColumn.getProperty())) {
                selectBuilder.append(" ").append(entityColumn.getProperty().toUpperCase()).append(",");
                continue;
            }
            selectBuilder.append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    public static String getAllColumns(Class<?> entityClass) {
        List<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn()).append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    public static String getPrimaryKeyWhere(Class<?> entityClass) {
        List<EntityColumn> entityColumns = EntityHelper.getPKColumns(entityClass);
        StringBuilder whereBuilder = new StringBuilder();
        for (EntityColumn column : entityColumns) {
            whereBuilder.append(column.getColumn()).append(" = ?").append(" AND ");
        }
        return whereBuilder.substring(0, whereBuilder.length() - 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void initEntityNameMap(Class<?> entityClass) {
        Table table;
        if (entityTableMap.get(entityClass) != null) {
            return;
        }
        EntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !(table = entityClass.getAnnotation(Table.class)).name().equals("")) {
            entityTable = new EntityTable();
            entityTable.setTable(table);
        }
        if (entityTable == null) {
            entityTable = new EntityTable();
            entityTable.name = EntityHelper.camelhumpToUnderline(entityClass.getSimpleName()).toUpperCase();
        }
        entityTableMap.put(entityClass, entityTable);
        List<Field> fieldList = EntityHelper.getAllField(entityClass, null);
        ArrayList<EntityColumn> columnList = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> pkColumnList = new ArrayList<EntityColumn>();
        for (Field field : fieldList) {
            if (field.isAnnotationPresent(Transient.class)) continue;
            EntityColumn entityColumn = new EntityColumn();
            if (field.isAnnotationPresent(Id.class)) {
                entityColumn.setId(true);
            }
            String columnName = null;
            if (field.isAnnotationPresent(Column.class)) {
                Column column = field.getAnnotation(Column.class);
                columnName = column.name();
            } else {
                columnName = EntityHelper.camelhumpToUnderline(field.getName());
            }
            entityColumn.setProperty(field.getName());
            entityColumn.setColumn(columnName.toUpperCase());
            entityColumn.setJavaType(field.getType());
            if (field.isAnnotationPresent(SequenceGenerator.class)) {
                SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
                if (sequenceGenerator.sequenceName().equals("")) {
                    throw new RuntimeException(entityClass + "\u5b57\u6bb5" + field.getName() + "\u7684\u6ce8\u89e3@SequenceGenerator\u672a\u6307\u5b9asequenceName!");
                }
                entityColumn.setSequenceName(sequenceGenerator.sequenceName());
            } else if (field.isAnnotationPresent(GeneratedValue.class)) {
                GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                if (generatedValue.generator().equals("UUID")) {
                    if (!field.getType().equals(String.class)) throw new RuntimeException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u4e3aUUID\uff0c\u4f46\u8be5\u5b57\u6bb5\u7c7b\u578b\u4e0d\u662fString");
                    entityColumn.setUuid(true);
                } else {
                    if (generatedValue.strategy() != GenerationType.IDENTITY) throw new RuntimeException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4e24\u79cd\u5f62\u5f0f\uff0c\u5168\u90e8\u6570\u636e\u5e93\u901a\u7528\u7684@GeneratedValue(generator=\"UUID\") \u6216\u8005 " + "\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"CALL IDENTITY()\"])");
                    entityColumn.setIdentity(true);
                    if (!generatedValue.generator().equals("")) {
                        entityColumn.setGenerator(generatedValue.generator());
                    }
                }
            }
            columnList.add(entityColumn);
            if (!entityColumn.isId()) continue;
            pkColumnList.add(entityColumn);
        }
        if (pkColumnList.size() == 0) {
            pkColumnList = columnList;
        }
        entityClassColumns.put(entityClass, columnList);
        entityClassPKColumns.put(entityClass, pkColumnList);
    }

    public static void main(String[] args) {
        System.out.println(EntityHelper.camelhumpToUnderline("userName"));
        System.out.println(EntityHelper.camelhumpToUnderline("userPassWord"));
        System.out.println(EntityHelper.camelhumpToUnderline("ISO9001"));
        System.out.println(EntityHelper.camelhumpToUnderline("hello_world"));
    }

    public static String camelhumpToUnderline(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (EntityHelper.isUppercaseAlpha(c)) {
                sb.append('_').append(c);
                continue;
            }
            sb.append(EntityHelper.toUpperAscii(c));
        }
        return sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static char toUpperAscii(char c) {
        if (EntityHelper.isUppercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    private static List<Field> getAllField(Class<?> entityClass, List<Field> fieldList) {
        Field[] fields;
        if (fieldList == null) {
            fieldList = new ArrayList<Field>();
        }
        if (entityClass.equals(Object.class)) {
            return fieldList;
        }
        for (Field field : fields = entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldList.add(field);
        }
        if (!(entityClass.getSuperclass() == null || entityClass.getSuperclass().equals(Object.class) || Map.class.isAssignableFrom(entityClass.getSuperclass()) || Collection.class.isAssignableFrom(entityClass.getSuperclass()))) {
            return EntityHelper.getAllField(entityClass.getSuperclass(), fieldList);
        }
        return fieldList;
    }

    public static class EntityColumn {
        private String property;
        private String column;
        private Class<?> javaType;
        private String sequenceName;
        private boolean id = false;
        private boolean uuid = false;
        private boolean identity = false;
        private String generator;

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }

        public void setJavaType(Class<?> javaType) {
            this.javaType = javaType;
        }

        public String getSequenceName() {
            return this.sequenceName;
        }

        public void setSequenceName(String sequenceName) {
            this.sequenceName = sequenceName;
        }

        public boolean isId() {
            return this.id;
        }

        public void setId(boolean id) {
            this.id = id;
        }

        public boolean isUuid() {
            return this.uuid;
        }

        public void setUuid(boolean uuid) {
            this.uuid = uuid;
        }

        public boolean isIdentity() {
            return this.identity;
        }

        public void setIdentity(boolean identity) {
            this.identity = identity;
        }

        public String getGenerator() {
            return this.generator;
        }

        public void setGenerator(String generator) {
            this.generator = generator;
        }
    }

    public static class EntityTable {
        private String name;
        private String catalog;
        private String schema;

        public void setTable(Table table) {
            this.name = table.name();
            this.catalog = table.catalog();
            this.schema = table.schema();
        }

        public String getName() {
            return this.name;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getPrefix() {
            if (this.catalog != null && this.catalog.length() > 0) {
                return this.catalog;
            }
            if (this.schema != null && this.schema.length() > 0) {
                return this.catalog;
            }
            return "";
        }
    }
}

