package com.fshows.yeepay.sdk.support;

import com.google.common.collect.Lists;
import com.yeepay.g3.sdk.yop.config.CertConfig;
import com.yeepay.g3.sdk.yop.config.CertStoreType;
import com.yeepay.g3.sdk.yop.config.SDKConfig;
import com.yeepay.g3.sdk.yop.config.provider.BaseFixedAppSdkConfigProvider;
import com.yeepay.g3.sdk.yop.encrypt.CertTypeEnum;

import java.util.List;

/**
 * @author liangyuanping
 * @version CustomSdkConfigProvider.java, v 0.1 2023-04-19 4:00 PM
 */
public class CustomSdkConfigProvider extends BaseFixedAppSdkConfigProvider {

    private static String YOP_PUBLIC_KEY;
    private static String YOP_PREFIX_URL;
    private static String APPID;

    /**
     * 自定义指定SDK配置的加载参数
     *
     * @return
     */
    @Override
    protected List<SDKConfig> loadCustomSdkConfig() {
        List<SDKConfig> sdkConfigs = Lists.newArrayList();
        SDKConfig sdkConfig = new SDKConfig();
        sdkConfig.setAppKey(APPID);
        sdkConfig.setServerRoot(YOP_PREFIX_URL);
        //yopPublicKey
        CertConfig certConfig = new CertConfig();
        CertTypeEnum certTypeEnum = CertTypeEnum.RSA2048;
        certConfig.setCertType(certTypeEnum);
        CertStoreType certStoreType = CertStoreType.STRING;
        certConfig.setStoreType(certStoreType);
        certConfig.setValue(YOP_PUBLIC_KEY);
        CertConfig[] yopPublicKey = new CertConfig[]{certConfig};
        sdkConfig.setYopPublicKey(yopPublicKey);
        //设置超时
        sdkConfig.setConnectTimeout(10000);
        sdkConfig.setReadTimeout(30000);
        sdkConfigs.add(sdkConfig);
        return sdkConfigs;
    }

    public CustomSdkConfigProvider() {

    }

    /**
     * 初始化参数
     *
     * @param yopPrefixUrl
     * @param yopPublicKey
     * @param appid
     */
    public CustomSdkConfigProvider(String yopPrefixUrl, String yopPublicKey, String appid) {
        this.YOP_PREFIX_URL = yopPrefixUrl;
        this.YOP_PUBLIC_KEY = yopPublicKey;
        this.APPID = appid;
    }

}