/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.order;

import com.fshows.yeepay.sdk.response.order.item.YopChannelPromotionInfoItemResponse;
import com.fshows.yeepay.sdk.response.order.item.YopInstallmentInfoItemResponse;
import com.fshows.yeepay.sdk.response.order.item.YopPayerInfoItemResponse;
import com.fshows.yeepay.sdk.response.order.item.YopPromotionInfoItemResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.List;

/**
 *
 *
 * @author
 * @version YopOrderQueryResponse.java, v 0.1 2023-04-20 10:13:00
 */
@Data
public class YopOrderQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555619771902L;


    /**
     * 返回码<br>OPR00000 成功(示例值：OPR00000)
     *
     * (选填)
     */
    private String code;

    /**
     * 返回信息
     *
     * (选填)
     */
    private String message;

    /**
     * -
     *
     * (选填)
     */
    private String bizSystemNo;

    /**
     * 收款商户编号
     *
     * (选填)
     */
    private String merchantNo;

    /**
     * 商户收款请求号
     *
     * (选填)
     */
    private String orderId;

    /**
     * 易宝收款订单号
     *
     * (选填)
     */
    private String uniqueOrderNo;

    /**
     * 订单状态<br>PROCESSING：订单待支付<br>SUCCESS：订单支付成功<br>TIME_OUT：订单已过期<br>FAIL:订单支付失败<br>CLOSE:订单关闭
     *
     * (选填)
     */
    private String status;

    /**
     * 订单金额.单位:元
     *
     * (选填)
     */
    private BigDecimal orderAmount;

    /**
     * 用户支付金额,单位:元(示例值：12.34)
     *
     * (选填)
     */
    private BigDecimal payAmount;

    /**
     * 商户手续费<br>商户承担的手续费金额.单位:元(示例值：0.54)
     *
     * (选填)
     */
    private BigDecimal merchantFee;

    /**
     * 用户手续费,用户付费场景下返回.单位:元(示例值：0.54)
     *
     * (选填)
     */
    private BigDecimal customerFee;

    /**
     * 支付成功时间(示例值：2021-01-01 00:00:00)
     *
     * (选填)
     */
    private String paySuccessDate;

    /**
     * 对账备注<br>商户自定义参数，会展示在交易对账单中
     *
     * (选填)
     */
    private String memo;

    /**
     * 支付方式<br>USER_SCAN：用户扫码MERCHANT_SCAN：商家扫码JS_PAY：JS支付MINI_PROGRAM：小程序支付WECHAT_OFFIACCOUNT：微信公众号支付ALIPAY_LIFE：生活号支付FACE_SCAN_PAY：刷脸支付SDK_PAY：SDK支付H5_PAY：H5支付ONEKEYPAY：一键支付BINDCARDPAY：绑卡支付E_BANK：网银支付ENTERPRISE_ACCOUNT_PAY：企业账户支付<br>ACCOUNT_BOOK_PAY: 记帐簿支付(示例值：USER_SCAN)
     *
     * (选填)
     */
    private String payWay;

    /**
     * 支付授权token，用于调用支付
     *
     * (选填)
     */
    private String token;

    /**
     * 分账都订单标识<br>分账订单标识:<br>DELAY_SETTLE:分账<br>REAL_TIME:不分账
     *
     * (选填)
     */
    private String fundProcessType;

    /**
     * 银行订单号<br>支付机构在银网联侧的单号,该单号也是支付机构在微信侧的外部商户订单号.<br>使用场景:<br>(1) 跨境报关<br>(2) 服务商用于点金计划商户小票功能
     *
     * (选填)
     */
    private String bankOrderId;

    /**
     * 渠道订单号<br>该笔订单在微信、支付宝或银行侧系统生成的单号
     *
     * (选填)
     */
    private String channelOrderId;

    /**
     * 渠道类型:<br>WECHAT：微信<br>ALIPAY：支付宝<br>UNIONPAY：银联<br>APPLEPAY：苹果支付<br>DCEP:数字人民币<br>仅聚合支付会返回该参数(示例值：DCEP)
     *
     * (选填)
     */
    private String channel;

    /**
     * 用户实际支付金额
     *
     * (选填)
     */
    private BigDecimal realPayAmount;

    /**
     * 剩余可分账金额;(用于分账的场景)
     *
     * (选填)
     */
    private BigDecimal unSplitAmount;

    /**
     * -
     *
     * (选填)
     */
    private BigDecimal totalRefundAmount;

    /**
     * 付款信息
     *
     * (选填)
     */
    private YopPayerInfoItemResponse payerInfo;

    /**
     * 渠道侧优惠列表
     *
     * (选填)
     */
    private List<YopChannelPromotionInfoItemResponse> channelPromotionInfo;

    /**
     * 易宝优惠列表
     *
     * (选填)
     */
    private List<YopPromotionInfoItemResponse> ypPromotionInfo;

    /**
     * 终端信息
     *
     * (选填)
     */
    private String terminalInfo;

    /**
     * 信用卡分期信息
     *
     * (选填)
     */
    private YopInstallmentInfoItemResponse installmentInfo;

    /**
     * 支付失败的失败原因
     *
     * (选填)
     */
    private String failReason;

    /**
     * 支付失败的code码
     *
     * (选填)
     */
    private String failCode;

}