/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.account;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 *
 * @author
 * @version YopAccountWithdrawOrderQueryResponse.java, v 0.1 2023-04-20 13:43:35
 */
@Data
public class YopAccountWithdrawOrderQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555324222714L;


    /**
     * 返回码<br>该参数代表本次请求的处理结果，UA00000为请求成功 若请求失败参看对应错误码和错误信息
     *
     * (选填)
     */
    private String returnCode;

    /**
     * 返回信息
     *
     * (选填)
     */
    private String returnMsg;

    /**
     * 商户请求号
     *
     * (选填)
     */
    private String requestNo;

    /**
     * 易宝提现订单号
     *
     * (选填)
     */
    private String orderNo;

    /**
     * 商户编号
     *
     * (选填)
     */
    private String merchantNo;

    /**
     * 提现金额
     *
     * (选填)
     */
    private BigDecimal orderAmount;

    /**
     * 到账金额<br>返回提现银行账户入账金额
     *
     * (选填)
     */
    private BigDecimal receiveAmount;

    /**
     * 扣账金额<br>返回易宝账户扣账金额（包含提现金额和手续费（若有））
     *
     * (选填)
     */
    private BigDecimal debitAmount;

    /**
     * 提现下单时间<br>返回易宝接收提现请求后创建订单时间(示例值：2020-06-01 01:00:00)
     *
     * (选填)
     */
    private String orderTime;

    /**
     * 提现完成时间<br>返回提现订单有明确结果（如订单状态为SUCCESS/FAIL）时的时间(示例值：2020-06-01 01:00:00)
     *
     * (选填)
     */
    private String finishTime;

    /**
     * 提现订单状态<br>可选项如下:<br>REQUEST_RECEIVE:请求已接收（易宝正在处理中，收到最终结果前请勿重复下单）<br>REQUEST_ACCEPT:请求已受理（易宝正在处理中，收到最终结果前请勿重复下单）<br>SUCCESS:已到账<br>FAIL:失败（该笔订单付款失败,可重新发起付款）<br>REMITING:银行处理中（银行正在处理中，收到最终结果前请勿重复下单）
     *
     * (选填)
     */
    private String status;

    /**
     * 失败原因当提现失败时，会返回失败原因(示例值：银行账户冻结)
     *
     * (选填)
     */
    private String failReason;

    /**
     * 手续费承担方商编<br>平台商承担时返回平台商商编商户承担时返回商户编号
     *
     * (选填)
     */
    private String feeUndertakerMerchantNo;

    /**
     * 手续费
     *
     * (选填)
     */
    private BigDecimal fee;

    /**
     * 2小时到账
     *
     * (选填)
     */
    private String receiveType;

    /**
     * 开户名
     *
     * (选填)
     */
    private String accountName;

    /**
     * 银行账号<br>返回商户的提现账户-银行账号(示例值：6222020403021234567)
     *
     * (选填)
     */
    private String accountNo;

    /**
     * 开户行名称<br>返回商户的提现账户-开户行名称(示例值：工商银行)
     *
     * (选填)
     */
    private String bankName;

    /**
     * 冲退标识<br>由于银行原因，会发生提现已到账后又通知冲退的情况（提现资金会原路退回到商户账户）
     *
     * (选填)
     */
    private Boolean isReversed;

    /**
     * 冲退时间<br>返回银行通知冲退时的时间(示例值：2020-06-01 01:10:00)
     *
     * (选填)
     */
    private String reverseTime;

    /**
     * 备注
     *
     * (选填)
     */
    private String remark;

}