/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author youmingming
 * @version YopBaseResponse.java, v 0.1 2022-02-09 下午5:00 youmingming
 */
@Data
public class YopBaseResponse<T> implements Serializable {
    private static final long serialVersionUID = -7057904697514071778L;
    private Boolean success;
    /**
     * 失败错误码
     */
    private String errorCode;

    /**
     * 失败原因
     */
    private String errorMessage;

    /**
     * 成功时返回，返回参数的集合，最大长度不限，除公共参数外所有返回参数(业务参数)都必须放在这里进行传递
     */
    private T returnValue;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}