/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.merchant;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.merchant.MerchantRegisterQueryResponse;
import com.fshows.yeepay.sdk.response.merchant.YopMerchantProductModifyResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version YopMerchantProductModifyRequest.java, v 0.1 2023-05-04 11:01:50
 */
@Data
public class YopMerchantProductModifyRequest  extends YopBizRequest<YopMerchantProductModifyResponse> {

    private static final long serialVersionUID = -2213838555972898917L;


    /**
     * 请求号
     *
     * (选填)
     */
    @Length(max = 64, message = "requestNo长度不能超过64")
    private String requestNo;

    /**
     * 上级商户编号<br>如果为平台商拓展商户（入驻商户），此为平台商商户编号；<br>如为saas服务商拓展商户（平台商/标准商户），此为saas服务商商户编号。
     *
     * (选填)
     */
    @Length(max = 32, message = "parentMerchantNo长度不能超过32")
    private String parentMerchantNo;

    /**
     * 需要变更产品的商户编号
     *
     * (选填)
     */
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 商户回调地址<br>1、用于接收电子签章地址，完成协议签署；2、用于接收变更完成的通知。<br><br>请参考&nbsp; <a href="#anchor7">入网结果通知</a>
     *
     * (选填)
     */
    @Length(max = 256, message = "notifyUrl长度不能超过256")
    private String notifyUrl;

    /**
     * 变更产品信息<br>请参考<a href="https://open.yeepay.com/docs/v2/products/fwssfk/others/5f59fc1720289f001ba82528/5fcef827d755b7001b31b09c/index.html">请参考变更产品信息</a> <br>1.变更产品信息和功能服务二选一必填(示例值：[{"productCode":"MERCHANT_SCAN_ALIPAY_OFFLINE","rateType":"SINGLE_PERCENT","percentRate":"0.1","undertaker":"PLATFORM_MERCHANT","paymentMethod":"REAL_TIME"}])
     *
     * (选填)
     */
    private String productInfo;

    /**
     * 产品资质<br>请参考&nbsp;&nbsp;<a href="https://open.yeepay.com/docs/products/ptssfk/others/5f3cef4420289f001ba82523/60a372bb9ed9dd001b437619">产品资质信息</a><br>1.开通POS产品必填 mcc；<br>2.开通企业付款-实时/两小时/次日必传付款场景，为了增加商户审核通过率，建议传付款业务协议图片/附件与付款业务系统截图/附件；如为特殊申请也需上传特批开通流程/截图(示例值：{"mcc":"7829","paymentScene":"RLZYFW","systemScreenshotUrl":"https://staticres.yeepay.com/xxx.文件后缀","specialPermitProcessUrl":"https://staticres.yeepay.com/xxx.文件后缀","agreementPhotoUrl":"https://staticres.yeepay.com/xxx.文件后缀"})
     *
     * (选填)
     */
    private String productQualificationInfo;

    /**
     * 结算账户信息<br>请参考&nbsp;<a href="https://open.yeepay.com/docs/v2/products/ptssfk/others/5f3cef4420289f001ba82523/5f3cf1f9b748dc001b877282/index.html">结算账户信息</a>(示例值：{ "settlementDirection":"结算方向", "bankCode":"开户总行编码", "bankAccountType":"银行账户类型", "bankCardNo":"银行账户号码" })
     *
     * (选填)
     */
    private String settlementAccountInfo;

    /**
     * 功能服务<br>请参考&nbsp;<a href="https://open.yeepay.com/docs/products/ptssfk/others/5f3cef4420289f001ba82523/622092d9dc5f55003ea93fe1">服务枚举信息</a><br>1.开通分账服务传SHARE<br>2.变更产品信息和功能服务二选一必填(示例值：["SHARE"])
     *
     * (选填)
     */
    private String functionService;

    /**
     * 功能服务配套资质信息<br>请参考&nbsp;<a href="https://open.yeepay.com/docs/products/fwssfk/others/5f59fc1720289f001ba82528/62208dcadc5f55003ea93fdf">服务资质信息</a><br>1.开通分账服务必传分账场景,为了增加商户审核通过率,建议同时上送分账证明(示例值：{"shareScene":"FZ_FJ001","shareCertificate":"https://staticres.yeepay.com/xxx.文件后缀"})
     *
     * (选填)
     */
    private String functionServiceQualificationInfo;

    @Override
    public Class<YopMerchantProductModifyResponse> getResponseClass() {
        return YopMerchantProductModifyResponse.class;
    }
}