/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.merchant;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.merchant.YopMerchantProductFeeQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * @author
 * @version YopMerchantProductFeeQueryRequest.java, v 0.1 2023-06-08 16:53:04
 */
@Data
public class YopMerchantProductFeeQueryRequest extends YopBizRequest<YopMerchantProductFeeQueryResponse> {

    private static final long serialVersionUID = -2213838555842409127L;


    /**
     * 上级商户编号<br>如果为平台商拓展商户（入驻商户），此为平台商商户编号；<br>如为saas服务商拓展商户（平台商/标准商户），此为saas服务商商户编号。
     * <p>
     * (选填)
     */
    private String parentMerchantNo;

    /**
     * 需要查询产品的商户编号
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 产品编码(示例值：MERCHANT_SCAN_ALIPAY_OFFLINE)
     * <p>
     * (选填)
     */
    private String productCode;

    @Override
    public Class<YopMerchantProductFeeQueryResponse> getResponseClass() {
        return YopMerchantProductFeeQueryResponse.class;
    }
}