/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.account;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.account.YopAccountWithdrawOrderQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

/**
 *
 * 提现-查询
 * @author
 * @version YopAccountWithdrawOrderQueryRequest.java, v 0.1 2023-04-20 13:43:35
 */
@Data
public class YopAccountWithdrawOrderQueryRequest extends YopBizRequest<YopAccountWithdrawOrderQueryResponse> {

    private static final long serialVersionUID = -2213838555933329805L;


    /**
     * 商户请求号<br>商户请求号，由商户自定义生成(与易宝提现订单号两者填其一)(示例值：WITHDRAW20200327103027)
     *
     * (选填)
     */
    @Length(max = 32, message = "requestNo长度不能超过32")
    private String requestNo;

    /**
     * 易宝提现订单号<br>易宝支付系统生成的提现订单号(与商户请求号两者填其一)(示例值：be54b037a981440a8cfcb0549aaf5344)
     *
     * (选填)
     */
    @Length(max = 32, message = "orderNo长度不能超过32")
    private String orderNo;

    /**
     * 商户编号(示例值：易宝支付分配的的商户唯一标识;示例值:100400612345)
     *
     * (选填)
     */
    private String merchantNo;

    @Override
    public Class<YopAccountWithdrawOrderQueryResponse> getResponseClass() {
        return YopAccountWithdrawOrderQueryResponse.class;
    }
}