/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.sdk.util;

import com.fshows.yeepay.sdk.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SignUtil {
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";

    private static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins != null && !StringUtils.isEmpty((CharSequence)algorithm)) {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = StreamUtil.readText(ins).getBytes();
            encodedKey = Base64.getDecoder().decode(encodedKey);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        return null;
    }

    private static String getContent(Map<String, String> param) {
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(param.keySet());
        Collections.sort(keys);
        int index = 0;
        for (String key : keys) {
            String value = param.get(key);
            if (!StringUtils.isNotBlank((CharSequence)key) || !StringUtils.isNotBlank((CharSequence)value)) continue;
            content.append(index == 0 ? "" : "&").append(key).append("=").append(value);
            ++index;
        }
        return content.toString();
    }

    private static String getVerifiedContent(Map<String, Object> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key) == null ? "" : params.get(key).toString();
            content.append(i == 0 ? "" : "&").append(key).append("=").append(value);
        }
        return content.toString();
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.getDecoder().decode(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }

    public static String sign(Map<String, String> data, String signType, String privateKey) {
        try {
            PrivateKey priKey = SignUtil.getPrivateKeyFromPKCS8(signType, new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            String content = SignUtil.getContent(data);
            signature.update(content.getBytes("utf-8"));
            byte[] signed = signature.sign();
            return new String(Base64.getEncoder().encode(signed));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String sign(String content, String signType, String privateKey) {
        try {
            PrivateKey priKey = SignUtil.getPrivateKeyFromPKCS8(signType, new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initSign(priKey);
            signature.update(content.getBytes("utf-8"));
            byte[] signed = signature.sign();
            return new String(Base64.getEncoder().encode(signed));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Boolean verifySign(Map<String, Object> data, String signType, String sign, String publicKey) {
        try {
            String content = SignUtil.getVerifiedContent(data);
            PublicKey pubKey = SignUtil.getPublicKeyFromX509(signType, new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
            signature.initVerify(pubKey);
            signature.update(content.getBytes("utf-8"));
            return signature.verify(Base64.getDecoder().decode(sign.getBytes()));
        }
        catch (Exception ex) {
            return null;
        }
    }
}

