package com.fshows.yeepay.sdk.response.order.item;

import lombok.Data;

import java.io.Serializable;

/**
 * 付款信息
 * @author liangyuanping
 * @version YopPayerInfoItemResponse.java, v 0.1 2023-04-20 10:24 AM
 */
@Data
public class YopPayerInfoItemResponse implements Serializable {

    /**
     * 银行编号，如：ABC、CBC等
     *
     * (选填)
     */
    private String bankId;

    /**
     * 账户名称.网银B2B支付会返回付款企业账户名称(示例值：易宝支付有限公司)
     *
     * (选填)
     */
    private String accountName;

    /**
     * 银行卡号（前6后4）(示例值：622848****0000)
     *
     * (选填)
     */
    private String bankCardNo;

    /**
     * 手机号（前3后4)(示例值：181****5651)
     *
     * (选填)
     */
    private String mobilePhoneNo;

    /**
     * 卡类型<br>DEBIT：借记卡CREDIT：贷记卡CFT：微信零钱QUASI_CREDIT：准贷记卡PUBLIC_ACCOUNT：对公账户（网银B2B支付返回）(示例值：CREDIT)
     *
     * (选填)
     */
    private String cardType;

    /**
     * 用户ID<br>微信支付返回openID<br>支付宝支付返回userID<br>银联支付返回userID<br>账户支付返回付款方商编(示例值：oUpF8uMuAJO_M2pxb1Q9zNjWeS6o)
     *
     * (选填)
     */
    private String userID;

    /**
     * 微信返回的unionID
     *
     * (选填)
     */
    private String unionID;

    /**
     * 支付宝买家登录账号<br>支付宝支付返回buyerLogonId
     *
     * (选填)
     */
    private String buyerLogonId;

    /**
     * 记帐簿编号
     *
     * (选填)
     */
    private String ypAccountBookNo;

}