/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.order;

import com.fshows.yeepay.sdk.response.order.item.YopBankPromotionInfoDTOListItemResponse;
import com.fshows.yeepay.sdk.response.order.item.YopPromotionInfoDTOListItemResponse;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 *
 *
 * @author
 * @version YopTradeRefundQueryResponse.java, v 0.1 2023-04-20 11:46:43
 */
@Data
public class YopTradeRefundQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555133737583L;


    /**
     * 返回码<br>结果码，OPR00000表示易宝受理成功，退款状态请以"status"为准(示例值：OPR00000)
     *
     * (选填)
     */
    private String code;

    /**
     * 返回信息，对应code的中文信息(示例值：成功)
     *
     * (选填)
     */
    private String message;

    /**
     * 商户编号
     *
     * (选填)
     */
    private String merchantNo;

    /**
     * 商户收款请求号
     *
     * (选填)
     */
    private String orderId;

    /**
     * 商户退款请求号
     *
     * (选填)
     */
    private String refundRequestId;

    /**
     * 易宝收款订单号
     *
     * (选填)
     */
    private String uniqueOrderNo;

    /**
     * 易宝退款订单号
     *
     * (选填)
     */
    private String uniqueRefundNo;

    /**
     * 退款申请金额,单位:元(示例值：12.92)
     *
     * (选填)
     */
    private BigDecimal refundAmount;

    /**
     * 退回商户手续费金额,单位:元(示例值：1.12)
     *
     * (选填)
     */
    private BigDecimal returnMerchantFee;

    /**
     * 退款状态<br>PROCESSING：退款处理中<br>SUCCESS：退款成功<br>FAILED：退款失败<br>CANCEL:退款关闭,商户通知易宝结束该笔退款后返回该状态<br>SUSPEND:退款中断,如需继续退款,请调用<a href="https://open.yeepay.com/docs/apis/ptssfk/jiaoyi/options__rest__v1.0__trade__refund__supply">上送卡信息退款</a>进行打款退款;如想结束退款,请调用<a href="https://open.yeepay.com/docs/apis/ptssfk/jiaoyi/options__rest__v1.0__trade__refund__end">结束退款</a>来关闭退款订单<br>说明:调用<a href="https://open.yeepay.com/docs/apis/bzshsfk/jiaoyi/options__rest__v1.0__trade__refund__fast">申请极速退款</a>、<a href="https://open.yeepay.com/docs/apis/bzshsfk/jiaoyi/options__rest__v1.0__trade__refund__supply">上送卡信息退款</a>、<a href="https://open.yeepay.com/docs/apis/bzshsfk/jiaoyi/options__rest__v1.0__trade__refund__end">结束退款</a>前,请联系易宝提前开通相应的退款服务。(示例值：SUCCESS)
     *
     * (选填)
     */
    private String status;

    /**
     * 退款原因的简要描述
     *
     * (选填)
     */
    private String description;

    /**
     * 退款受理时间(示例值：2021-01-01 00:00:00)
     *
     * (选填)
     */
    private String refundRequestDate;

    /**
     * 退款成功日期<br>退款成功时间(示例值：2021-01-01 00:00:00)
     *
     * (选填)
     */
    private String refundSuccessDate;

    /**
     * 退款失败原因
     *
     * (选填)
     */
    private String failReason;

    /**
     * 实际退款金额<br>用户付手续费场景下,实际退款金额即退款金额和退费金额之和
     *
     * (选填)
     */
    private BigDecimal realRefundAmount;

    /**
     * 用户实退金额(示例值：1.23)
     *
     * (选填)
     */
    private BigDecimal cashRefundFee;

    /**
     * 渠道侧优惠退回列表
     *
     * (选填)
     */
    private List<YopBankPromotionInfoDTOListItemResponse> bankPromotionInfoDTOList;


    /**
     * 易宝侧优惠退回列表
     *
     * (选填)
     */
    private List<YopPromotionInfoDTOListItemResponse> ypPromotionInfoDTOList;

    /**
     * 退款资金来源信息 <br>debitAmount：扣账金额 <br>accountType：扣账资金来源<br>扣账资金来源枚举值：<br>FUND_ACCOUNT：资金账户余额 <br>DIVIDE_ACCOUNT：分账账户余额 <br>SETTLE_ACCOUNT：待结算账户余额(示例值：[{"accountType":"FUND_ACCOUNT","debitAmount":6.00}])
     *
     * (选填)
     */
    private String refundAccountDetail;

    /**
     * 退款入账信息
     *
     * (选填)
     */
    private String channelReceiverInfo;

}