/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.response.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 银行转账支付响应
 *
 * @author
 * @version YopBankTransferResponse.java, v 0.1 2025-11-07
 */
@Data
public class YopBankTransferResponse implements Serializable {

    private static final long serialVersionUID = -2213838555676681322L;

    /**
     * 返回码
     */
    private String code;

    /**
     * 返回信息
     */
    private String msg;

    /**
     * 支付状态<br>
     * WAIT_CHECK:等待付款方转账<br>
     * FAIL:支付失败
     */
    private String payStatus;

    /**
     * 附言<br>
     * 校验模式为固定账户号+动态附言模式（REMARKCODE）时，该参数内容为10位小写英文字母+数字的附言码<br>
     * 校验模式为动态账户号模式（ACCOUNTNO）时，该参数为空
     */
    private String remitRemarkCode;

    /**
     * 付款方名称
     */
    private String payerAccountName;

    /**
     * 收款方名称
     */
    private String receiveName;

    /**
     * 收款方账号
     */
    private String receiveAccountNo;

    /**
     * 收款方开户行
     */
    private String accountName;

    /**
     * 省市／地区
     */
    private String areaInfo;

    /**
     * 转账金额
     */
    private BigDecimal amount;

    /**
     * 易宝收款订单号
     */
    private String uniqueOrderNo;

    /**
     * 付款方账户号
     */
    private String payerAccountNo;
}