/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.yeepay.sdk.request.merchant;

import com.fshows.yeepay.sdk.request.YopBizRequest;
import com.fshows.yeepay.sdk.response.merchant.YopMerchantProductModifyResponse;
import com.fshows.yeepay.sdk.response.merchant.YopMerchantProductQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

/**
 *
 *
 * @author
 * @version YopMerchantProductQueryRequest.java, v 0.1 2023-05-04 11:36:24
 */
@Data
public class YopMerchantProductQueryRequest  extends YopBizRequest<YopMerchantProductQueryResponse> {

    private static final long serialVersionUID = -2213838555629437246L;


    /**
     * 商户产品变更请求号(示例值：0adc579914d541f8baa3be75387846f1)
     *
     * (选填)
     */
    @Length(max = 64, message = "requestNo长度不能超过64")
    private String requestNo;

    @Override
    public Class<YopMerchantProductQueryResponse> getResponseClass() {
        return YopMerchantProductQueryResponse.class;
    }
}