/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.payment;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wujn
 * @version OrderQueryResponse.java, v 0.1 2020-04-27 8:55 PM wujn
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class VbillOrderQueryResponse extends VbillBizResponse {

    private static final long serialVersionUID = -8595294315251692347L;

    /**
     * 商户订单号
     */
    private String ordNo;

    /**
     * 科技公司订单号
     */
    private String uuid;

    /**
     * 落单号，供退款和退款查询使用
     */
    private String sxfUuid;

    /**
     * 交易支付完成时间,格式yyyyMMddHHmmss
     */
    private String payTime;

    /**
     * 交易时间,格式yyyyMMddHHmmss
     */
    private String tranTime;

    /**
     * 渠道商商户号
     */
    private String channelId;

    /**
     * 支付宝买家登录账号
     */
    private String buyerAccount;

    /**
     * 交易金额
     */
    private String oriTranAmt;

    /**
     * 商家实收(应结金额)
     */
    private String settleAmt;

    /**
     * 消费者付款金额
     */
    private String totalOffstAmt;

    /**
     * 支付场景，1：刷卡 2：声波3：刷脸
     * 不上传默认为 1
     */
    private String scene;

    /**
     * TQ 机具编号，支付来源为硬件时，该参数为必传；
     */
    private String terminalId;

    /**
     * 设备号
     */
    private String deviceNo;

    /**
     * 是否做分账分账交易使用；00：做；01：不做；不传默认为不做分账
     */
    private String ledgerAccountFlag;

    /**
     * 是否已做分账 00:是，01:否
     */
    private String ledgerAccountStatus;

    /**
     * 银联对账 key
     */
    private String reconKey;

    /**
     * 支付渠道，对订单的描述，取值范围：WECHAT: 微 信 ,ALIPAY: 支 付宝 ,UNIONPAY:银联
     */
    private String payType;

    /**
     * 支付方式：02 公众号/服务窗/js支付 03小程序
     */
    private String payWay;

    /**
     * 付款银行，例如 ICBC
     */
    private String payBank;

    /**
     * 商户店铺名称
     */
    private String storeName;

    /**
     * 订单标题
     */
    private String subject;

    /**
     * 备用
     */
    private String extend;

    /**
     * 买家用户号支付宝渠道：买家支付宝用户号buyer_user_id微信渠道：
     * 微信平台的sub_openid
     */
    private String buyerId;

    /**
     * 交易状态：
     * SUCCESS 交易成功，
     * FAIL 交易失败，
     * PAYING 支 付中，
     * NOTPAY 未 支付，
     * CLOSED 已 关闭，
     * CANCELED 已撤销
     */
    private String tranSts;

    /**
     * 00: 线下标准 、 01: 线 上标准、 02: 蓝海 、 \
     * 03: 绿洲 、 04: 线 下缴费、 05: 线下 保 险 、
     * 06:线下非赢利、07: 高校食堂，08：私立院校，09：其他
     */
    private String activityNo;

    /**
     * 姓名；实名支付时该参数必反
     */
    private String buyerNameEnc;

    /**
     * 证件类型；实名支付该参数必反
     */
    private String buyerIdType;

    /**
     * 证件号；实名支付时该参数必反
     */
    private String buyerIdNoEnc;

    /**
     * 微信/支付宝流水号支付宝渠道：支付宝交易流水微信渠道：微信交易流水
     */
    private String transactionId;

    /**
     * 交易手续费率；单位%
     */
    private String recFeeRate;

    /**
     * 交易手续费；
     */
    private String recFeeAmt;

    /**
     * 优惠信息
     */
    private String promotionDetail;

    /**
     * 积分支付金额
     * 说明：当前pointAmount如果有值的话应当计算到预充值代金券金额
     *     预充值金额=promotionDetail解析出的预充值金额+pointAmount
     */
    private String pointAmount;
}
