/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.MerchantSignUrlResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version MerchantSignUrl.java, v 0.1 2020-04-22 17:57
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantSignUrlRequest extends VbillBizRequest<MerchantSignUrlResponse> {

    private static final long serialVersionUID = 5994228754503852140L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 签约类型
     * 00:接口签约
     * 01:短信签约
     */
    @NotBlank
    private String signType;

    @Override
    public Class<MerchantSignUrlResponse> getResponseClass() {
        return MerchantSignUrlResponse.class;
    }
}