/**
 * fshows.com
 * Copyright (C) 2013-2018 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantHSHFeedModifyResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author chenjn
 * @version MerchantHSHFeedModifyRequest.java, v 0.1 2021-10-19 15:45 chenjn
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantHSHFeedModifyRequest extends VbillBizRequest<MerchantHSHFeedModifyResponse> {
    private static final long serialVersionUID = 1413155167114526070L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;
    /**
     * 商户简称
     * 1、字母、数字、汉字都算 1 个字符，最长 20 个字符；
     * 2、显示给消费者看的商户名称，会显示支付页面中。建议填入实际经营的内容，如 XX快餐店/XX 炸鸡
     */
    @NotBlank(message = "商户简称不能为空")
    private String mecDisNm;
    /**
     * 商户联系手机号
     * 1、个人资质商户请传入在运营商实名认证过的商户负责人手机号
     * 2、企业资质商户传入企业联系人电话
     */
    @NotBlank(message = "商户联系手机号不能为空")
    private String mblNo;
    /**
     * 经营类型
     * 取值范围：01 线下 02 线上
     */
    @NotBlank(message = "经营类型不能为空")
    private String operationalType;
    /**
     * 资质类型
     * 取值范围：01 自然人 02 个体户 03 企业线上商户必须是 03 企业类型
     */
    @NotBlank(message = "资质类型不能为空")
    private String haveLicenseNo;
    /**
     * 商户类型
     * 取值范围： 00 普通单店商户（非连锁商户）01 连锁总 02 连锁分 03 1+n 总 04 1+n 分
     * 说明：
     * （1）非连锁商户直接传入 00 即可。
     * （2）连锁总店、1+N 总店请传入 01、03，请勿当做普通商户进件。
     * （3）连锁总店、1+n 总店丌支持自然人进件
     * （4）1+n 分店丌支持企业资质商户。
     */
    @NotBlank(message = "商户类型不能为空")
    private String mecTypeFlag;

    /**
     * 所属总店商户编号
     */
    private String parentMno;

    /**
     * 分店是否独立结算
     * 01独立结算\
     * 02统一结算
     * 说明: (1)商户类型是02(连锁分店)时必传此参数.
     * (2)其他情况传入无效,系统强制为01独立结算
     */
    private String independentModel;
    /**
     * 营业执照注册名称
     * 企业、个体户必传
     * 最大 122 个汉字，需确保和营业执照照片一致
     * 注意：如果个体户营业执照中没有注册名称或注
     * 册名称是***，此处需要按照“个体户+法人姓名”
     * 的格式传入，例如：个体户张三
     */
    private String cprRegNmCn;
    /**
     * 营业执照注册号
     * 企业、个体户必传
     * 营业执照号|统一信用编码最大 80 位数字
     */
    private String registCode;
    /**
     * 营业执照起始日
     */
    private String businessLicStt;
    /**
     * 营业执照到期日
     */
    private String businessLicEnt;
    /**
     * 营业执照有效期是否长期有效
     * haveLicenseNo传入01时必传
     * 00否 01是
     */
    private String businessLicEffict;
    /**
     * 商户经营详细地址
     * 1、传入商户实际经营地信息
     * 2、详细地址无需填入省市区信息， 直接填写详细街道门牉号即可
     */
    @NotBlank(message = "商户经营详细地址不能为空")
    private String cprRegAddr;
    /**
     * 商户经营地址省编码
     * 参见省市区代码表
     */
    @NotBlank(message = "商户经营地址省编码不能为空")
    private String regProvCd;
    /**
     * 商户经营地址市编码
     * 参见省市区代码表
     */
    @NotBlank(message = "商户经营地址市编码不能为空")
    private String regCityCd;
    /**
     * 商户经营地址区编码
     * 参见省市区代码表
     */
    @NotBlank(message = "商户经营地址区编码不能为空")
    private String regDistCd;
    /**
     * 经营类目
     * 参见类目 ID 附件
     * 注意：商户入网时请选择正确 MCC 入网。对于需要报名 AT 活劢（蓝海/微信智慧餐饮/微信高校食堂）的商户，请按照上游要求的 MCC 进件，
     * 否则会导致后期报名 AT 活劢失败。MCC 要求详见 AT 活劢报名接口文档。
     */
    @NotBlank(message = "经营类目不能为空")
    private String mccCd;
    /**
     * 客服电话
     * 数字，不能有 -
     */
    @NotBlank(message = "客服电话不能为空")
    private String csTelNo;
    /**
     * 法人/商户负责人
     */
    @NotBlank(message = "法人/商户负责人不能为空")
    private String identityName;
    /**
     * 法人/商户负责人证件类型
     * 00 身份证 写死
     */
    @NotBlank(message = "法人/商户负责人证件类型不能为空")
    private String identityTyp;
    /**
     * 法人/商户负责人证件号
     */
    @NotBlank(message = "法人/商户负责人证件号不能为空")
    private String identityNo;
    /**
     * 法人/商户负责人证件起始日
     */
    private String legalPersonLicStt;
    /**
     * 法人/商户负责人证件到期日
     * 【法人证件是否长期】若为00则该字段必传
     */
    private String legalPersonLicEnt;
    /**
     * 法人证件是否长期有效 00否  01是
     */
    private String legalPersonLicEffict;
    /**
     * 结算账户名
     * 说明：
     * 1、对公结算时账户名需不注册名一致；
     * 2、自然人商户、线上类商户丌允许授权结算
     */
    @NotBlank(message = "结算账户名不能为空")
    private String actNm;
    /**
     * 结算人证件号
     * 对私结算必传
     */
    private String stmManIdNo;
    /**
     * 结算人证件号起始日
     */
    private String accountLicStt;
    /**
     * 结算人证件号到期日
     */
    private String accountLicEnt;
    /**
     * 结算人证件是否长期
     * settleType不为00时必传
     * 00否  01是
     */
    private String accountLicEffict;
    /**
     * 结算卡号
     */
    @NotBlank(message = "结算卡号不能为空")
    private String actNo;
    /**
     * 结算账户类型
     * 00:对公
     * 01:对私
     */
    private String actTyp;
    /**
     * 开户行总行行号
     */
    private String bnkCd;
    /**
     * 开户行大行名称
     */
    private String bnkNm;
    /**
     * 开户支行联行行号
     */
    @NotBlank(message = "开户支行联行行号不能为空")
    private String lbnkNo;
    /**
     * 开户支行名称
     */
    private String lbnkNm;
    /**
     * 开户支行所在省编码
     */
    private String lbnkProv;
    /**
     * 开户支行所在市编码
     */
    private String lbnkCity;
    /**
     * 00对私法人
     * 01对私非法人
     * 02对公结算
     */
    private String settleType;

    /**
     * 税务登记证图片
     */
    private String taxRegistLicensePic;

    /**
     * 法人身份证正面 （人像面）
     */
    @NotBlank(message = "法人身份证正面照片不能为空")
    private String legalPersonidPositivePic;

    /**
     * 银行卡正面，对私结算必传
     */
    private String bankCardPositivePic;

    /**
     * 法人身份证反面 （国徽面）
     */
    @NotBlank(message = "法人身份证反面照片不能为空")
    private String legalPersonidOppositePic;

    /**
     * 开户许可证,对公结算必传
     */
    private String openingAccountLicensePic;

    /**
     * 银行卡反面 (非必填)
     */
    private String bankCardOppositePic;

    /**
     * 商户协议照片
     */
    private String merchantAgreementPic;

    /**
     * 门头照片
     */
    @NotBlank(message = "门头照不能为空")
    private String storePic;

    /**
     * 经营场所-含收银台
     */
    @NotBlank(message = "收银台照片不能为空")
    private String businessPlacePic;

    /**
     * 租赁协议一(封面)（非必传）
     */
    private String leaseAgreementOnePic;

    /**
     * 租赁协议二(面积、有效期页)（非必传）
     */
    private String leaseAgreementTwoPic;

    /**
     * 租赁协议三(签章页)（非必传）
     */
    private String leaseAgreementThreePic;

    /**
     * 其他资料照片1（非必传）
     */
    private String otherMaterialPictureOne;

    /**
     * 其他资料照片2（非必传）
     */
    private String otherMaterialPictureTwo;

    /**
     * 其他资料照3（非必传）
     */
    private String otherMaterialPictureThree;

    /**
     * 其他资料照片4（非必传）
     */
    private String otherMaterialPictureFour;

    /**
     * 其他资料照5（非必传）
     */
    private String otherMaterialPictureFive;

    /**
     * 结算人身份证正面 （人像面）
     */
    private String settlePersonIdcardPositive;

    /**
     * 结算人身份证反面（国徽面）
     */
    private String settlePersonIdcardOpposite;

    /**
     * 营业执照,有照商户必传
     */
    private String licensePic;

    /**
     * 组织机构代码证（非必传）
     */
    private String orgCodePic;

    /**
     * 手持身份证（人像面）照片，（非必传）
     */
    private String handIdcardPic;

    /**
     * 非法人结算授权函,对私授权结算必传
     */
    private String letterOfAuthPic;

    /**
     * 真实商户内景图片
     */
    @NotBlank(message = "真实商户内景图片照片不能为空")
    private String insideScenePic;

    /**
     * 统一结算无营业执照说明,1+N分店且无营业执照必传
     */
    private String unionSettleWithoutLicense;

    @Override
    public Class<MerchantHSHFeedModifyResponse> getResponseClass() {
        return MerchantHSHFeedModifyResponse.class;
    }
}