/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.account;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.account.CapitalQuerySettlementResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version CapitalQuerySettlementRequest.java, v 0.1 2020-04-27 21:16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CapitalQuerySettlementRequest extends VbillBizRequest<CapitalQuerySettlementResponse> {

    private static final long serialVersionUID = -6950154571646282170L;

    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 结算时间
     */
    private String queryTime;

    /**
     * 结算流水号
     */
    private String serialNo;

    @Override
    public Class<CapitalQuerySettlementResponse> getResponseClass() {
        return CapitalQuerySettlementResponse.class;
    }
}