/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.vbill.sdk.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.vbill.sdk.client.VbillClient;
import com.fshows.vbill.sdk.exception.VbillApiException;
import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.BaseVbillResponse;
import com.fshows.vbill.sdk.response.VbillBizResponse;
import com.fshows.vbill.sdk.sign.DefaultSigner;
import com.fshows.vbill.sdk.sign.Signer;
import com.fshows.vbill.sdk.util.DefaultHttpRequest;
import com.fshows.vbill.sdk.util.HttpRequest;
import com.fshows.vbill.sdk.util.ReqIdUtil;
import com.fshows.vbill.sdk.util.ValidateUtil;
import com.fshows.vbill.sdk.util.VbillHashMap;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVbillClient
implements VbillClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultVbillClient.class);
    private static final String SUCCESS_CODE = "0000";
    private Signer signer;
    private HttpRequest httpRequest;
    private String fubeiPrivateKey;
    private String vbillPublicKey;

    public DefaultVbillClient() {
    }

    public DefaultVbillClient(Signer signChecker, HttpRequest request, String vbillPublicKey, String fubeiPrivateKey) {
        this.signer = signChecker;
        this.httpRequest = request;
        this.fubeiPrivateKey = fubeiPrivateKey;
        this.vbillPublicKey = vbillPublicKey;
    }

    public DefaultVbillClient(String vbillPublicKey, String fubeiPrivateKey) {
        this(new DefaultSigner(), new DefaultHttpRequest(), vbillPublicKey, fubeiPrivateKey);
    }

    @Override
    public <T extends VbillBizResponse> BaseVbillResponse<T> execute(String serverUrl, VbillBizRequest<T> request, String orgId, String reqId, String version, boolean isSign, boolean isVerifySign, Integer timeout) throws VbillApiException {
        long beginTime = System.currentTimeMillis();
        log.info("\u3010vbill-sdk\u3011\u8bf7\u6c42\u5f00\u59cb reqId={},url={},request={},begin={}", new Object[]{reqId, serverUrl, JSON.toJSONString(request, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), beginTime});
        this.validateParam(request, serverUrl);
        if (this.signer == null) {
            this.signer = new DefaultSigner();
        }
        if (this.httpRequest == null) {
            this.httpRequest = new DefaultHttpRequest();
        }
        try {
            String requestData = this.getRequestData(request, orgId, reqId, version, isSign);
            String result = this.httpRequest.post(serverUrl, requestData, timeout);
            log.info("\u3010vbill-sdk\u3011\u8bf7\u6c42\u7ed3\u675f reqId={},url={},request={},response={},cost={}ms", new Object[]{reqId, serverUrl, JSON.toJSONString(request, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), result, System.currentTimeMillis() - beginTime});
            return this.parseResponse(request, isVerifySign, result);
        }
        catch (Exception ex) {
            throw new VbillApiException(ex.getMessage(), ex);
        }
    }

    @Override
    public <T extends VbillBizResponse> BaseVbillResponse<T> execute(String serverUrl, VbillBizRequest<T> request, String orgId, String reqId) throws VbillApiException {
        return this.execute(serverUrl, request, orgId, reqId, null, true, true, 10000);
    }

    private <T extends VbillBizResponse> BaseVbillResponse<T> parseResponse(VbillBizRequest<T> request, boolean isVerifySign, String result) throws VbillApiException {
        JSONObject jsonObject = JSON.parseObject((String)result);
        String code = jsonObject.getString("code");
        String msg = jsonObject.getString("msg");
        if (StringUtils.isBlank((CharSequence)code) || !code.equals(SUCCESS_CODE)) {
            throw new VbillApiException(MessageFormat.format("[{0}]{1}", code, msg));
        }
        if (isVerifySign) {
            String respSign = jsonObject.getString("sign");
            String respSignType = jsonObject.getString("signType");
            if (StringUtils.isBlank((CharSequence)respSign) || StringUtils.isBlank((CharSequence)respSign)) {
                throw new VbillApiException("\u8fd4\u56de\u7b7e\u540d\u4e3a\u7a7a\u6216\u7b7e\u540d\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7b7e\u540d\u4fe1\u606f");
            }
            boolean signCheckResult = this.signer.verifySign(jsonObject.getInnerMap(), respSignType, respSign, this.vbillPublicKey);
            if (!signCheckResult) {
                throw new VbillApiException("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7b7e\u540d\u4fe1\u606f");
            }
        }
        BaseVbillResponse<VbillBizResponse> response = new BaseVbillResponse<VbillBizResponse>();
        response.setReqId(jsonObject.getString("reqId"));
        response.setMsg(jsonObject.getString("msg"));
        response.setCode(jsonObject.getString("code"));
        response.setOrgId(jsonObject.getString("orgId"));
        response.setRespData((VbillBizResponse)JSON.parseObject((String)jsonObject.getString("respData"), request.getResponseClass()));
        return response;
    }

    private <T extends VbillBizResponse> void validateParam(VbillBizRequest<T> request, String serverUrl) {
        if (request == null) {
            throw new IllegalArgumentException("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.fubeiPrivateKey)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.vbillPublicKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)serverUrl)) {
            throw new IllegalArgumentException("api\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
    }

    private <T extends VbillBizResponse> String getRequestData(VbillBizRequest<T> request, String orgId, String reqId, String version, boolean isSign) {
        VbillHashMap signMap = new VbillHashMap();
        signMap.put("orgId", orgId);
        signMap.put("reqId", StringUtils.isBlank((CharSequence)reqId) ? ReqIdUtil.getId() : reqId);
        signMap.put("timestamp", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        signMap.put("version", StringUtils.isBlank((CharSequence)version) ? "1.0" : version);
        signMap.put("signType", "RSA");
        signMap.put("reqData", JSON.toJSONString(request));
        if (isSign) {
            String sign = this.signer.sign(signMap, "RSA", this.fubeiPrivateKey);
            signMap.put("sign", sign);
        }
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.putAll(signMap);
        param.put("reqData", request);
        return JSON.toJSONString(param);
    }
}

