/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.payment;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import lombok.Data;

/**
 * @author Liluqing
 * @version VbillRefundQueryResponse.java, v 0.1 2020-06-10 14:29
 */
@Data
public class VbillRefundQueryResponse extends VbillBizResponse {

    /**
     * 商户订单号
     */
    private String ordNo;

    /**
     * 科技公司订单号
     */
    private String uuid;

    /**
     * 平台方订单号（微信/支付宝/银联）
     */
    private String transactionId;

    /**
     * 退款状态:
     * REFUNDSUC 退款成功
     * REFUNDFAIL 退款失败
     * REFUNDING 退款中
     */
    private String tranSts;

    /**
     * 退款成功时间,例如: 20180529121210
     */
    private String payTime;

    /**
     * 银联对账 key
     */
    private String reconKey;

    /**
     * 退款金额
     */
    private String refundAmount;

    /**
     * 出款金额
     */
    private String realRefundAmount;

    /**
     * 原订单金额
     */
    private String totalAmount;

    /**
     * 交易手续费；单位元
     */
    private String recFeeAmt;

    /**
     * 代金券退款金额积分支付金额，优惠金额或折扣券的金额
     */
    private String pointAmount;

    /**
     * 优惠券退款信息
     */
    private String refundDetail;

    /**
     * 退货原因
     */
    private String refundReason;

    /**
     * 备用
     */
    private String extend;
}