/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.other;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author yangdw
 * @version MerchantSignResult.java, v 0.1 2020-04-22 18:15
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantSignResponse extends VbillBizResponse {

    /**
     * 签署结果
     * 00:已发送链接,未签约
     * 01:签约失败
     * 02:签约成功
     * 03:未签约
     */
    private String signResult;

    /**
     * 签约时间，签约成功时必返回
     * 注:11月21日前签约商户该参数为空
     */
    private String signTime;
}   