/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.payment.VbillJsPayResponse;
import lombok.Data;

/**
 * js支付-聚合支付
 *
 * @author Liluqing
 * @version JsPayParam.java, v 0.1 2020-04-23 11:07
 */
@Data
public class VbillJsPayRequest extends VbillBizRequest<VbillJsPayResponse> {

    /**
     * 随行付商编
     */
    private String mno;
    /**
     * 商户订单号,64个字符以内、只能包含字母、数字、下划线；
     * 需保证在商户端不重复
     */
    private String ordNo;

    /**
     * 子商户号
     */
    private String subMechId;

    /**
     * 订单总金额，单位为元，精确到小数点后两位，取值范围
     * <p>
     * [0.01,100000000]
     */
    private String amt;

    /**
     * 参与优惠金额，单位元，精确到小数点后两位[0.01,100000000]；
     * 支付宝专用
     */
    private String discountAmt;

    /**
     * 不参与优惠金额，单位元，精确到小数点后两位[0.01,100000000]；
     * 支付宝专用
     */
    private String unDiscountAmt;

    /**
     * 支付渠道，对订单的描述，取值范围：WECHAT:微 信,ALIPAY:支付宝，UNIONPAY:银联
     */
    private String payType;

    /**
     * 支付方式：02 公众号/服务窗/js支付 03小程序
     */
    private String payWay;

    /**
     * 订单失效时间,以分种为单位，最短失效时间为1 分钟，最长失效时间为 1440分钟，该参数数值不接受小数点
     * （不传则默认 5 分钟失效）
     */
    private String timeExpire;

    /**
     * 限制卡类型
     * 00-全部
     * 01-限定不能使用信用卡支付
     * 默认值 00
     */
    private String limitPay;

    /**
     * 订单标题
     */
    private String subject;

    /**
     * 花呗分期数
     */
    private String hbFqNum;

    /**
     * 卖家承担分期服务费比例；不上送默认由买家承担
     */
    private String hbFqPercent;

    /**
     * 交易来源；
     * 01：服务商
     * 02：收银台
     * 03：硬件
     */
    private String tradeSource;

    /**
     * 交易 ip 地址
     */
    private String trmIp;

    /**
     * 持卡人 ip 地址
     * 银联js支付时，该参数必传
     */
    private String customerIp;

    /**
     * 用户号微信：openid；支付宝：userid；银联：userid；微信&支付宝必传，银联js为非必传
     */
    private String userId;

    /**
     * 微信子公众号非必填
     */
    private String subAppid;

    /**
     * js支付，前台成功通知地址
     */
    private String outFrontUrl;

    /**
     * js支付，前台事变通知地址
     * （与成功地址同时存在或同时不存在）
     */
    private String outFrontFailUrl;

    /**
     * 支付结果通知地址
     */
    private String notifyUrl;

    /**
     * 电子发票功能微信开具电子发票使用；目前仅支持微信；
     * 交易渠道为支付宝、银联时上送该参数则返回错00:是，01:否
     */
    private String needReceipt;


    /**
     * 是否做分账分账交易使用；00：做；01：不做；不传默认为不做分账
     */
    private String ledgerAccountFlag;

    /**
     * 分账有效时间单位为天；
     * 是否做分账选择00 时该字段必传；
     * 最大支持上送：
     * 30 ；注：从发起交易日期记为 1
     */
    private String ledgerAccountEffectTime;

    /**
     * 银联终端号
     */
    private String ylTrmNo;

    /**
     * TQ 机具编号，支付来源为硬件时，该参数为必传；
     */
    private String terminalId;

    /**
     * 设备号
     */
    private String deviceNo;

    /**
     * 是否实名支付：00：是，01：否 不传默认为 01;00 时；买家姓名、证件类型、证件号为必填
     */
    private String identityFlag;

    /**
     * 证件类型 : 大陆 ： IDCARD ；目前仅支持大陆证件号
     */
    private String buyerIdType;

    /**
     * 证件号:证件号只允许等于 18位
     */
    private String buyerIdNo;

    /**
     * 买家姓名
     */
    private String buyerName;

    /**
     * 手机号
     */
    private String mobileNum;

    /**
     * 备用
     */
    private String extend;

    /**
     * 订单优惠标识
     * 00：是，01：否；目前仅支持微信；交易渠道为支付宝、银联时上送该参数则返回错误
     */
    private String goodsTag;

    /**
     * 优惠详情信息(json 格式，里面内容见下面说明)
     */
    private String couponDetail;

    /**
     * 微信优惠参数
     */
    private String wxGoodsTag;

    /**
     * 支付宝扫码点餐类型:
     * qr_order（店内扫码点餐），
     * pre_order （预点到店自提），
     * home_delivery（ 外 送 到 家 ） ，
     * direct_payment（ 直 接 付 款 ） ，
     * other（其他）
     */
    private String alipayFoodOrderType;

    /**
     * 微信扫码点餐标识，最大长度32位
     * 注：目前需上送：FoodOrder
     */
    private String wechatFoodOrder;

    /**
     * 门店编号，长度32位
     * 对应支付宝store_id
     */
    private String storeId;

    /**
     * 蚂蚁门店编号
     * 支付宝未来校园活动必传
     */
    private String alipayStoreId;

    /**
     * 随行付门店编号，长度32位
     */
    private String storeNum;

    /**
     * 银联扫码点餐-门店标识，长度288位
     */
    private String addnInfo;

    /**
     * 支付宝校园场景ID
     */
    private String eduSchoolId;

    /**
     * 支付宝校园场景ID
     */
    private String eduScene;

    @Override
    public Class<VbillJsPayResponse> getResponseClass() {
        return VbillJsPayResponse.class;
    }
}