/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantIncomeEditResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;

/**
 * @author zhoujp
 * @version MerchantIncomeRequest.java, v 0.1 2020-04-28 11:07 zhoujp
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantIncomeUpdateRequest extends VbillBizRequest<MerchantIncomeEditResponse> {
    private static final long serialVersionUID = 8877676625096482171L;

    /**
     * 随行付商编
     */
    @NotBlank(message = "mno不能为空")
    private String mno;

    /**
     * 商户简称
     * 1、字母、数字、汉字都算 1 个字符，最长 20 个字符；
     * 2、显示给消费者看的商户名称，会显示支付页面中。建议填入实际经营的内容，如 XX快餐店/XX 炸鸡
     */
    private String mecDisNm;
    /**
     * 商户联系手机号
     * 1、个人资质商户请传入在运营商实名认证过的商户负责人手机号
     * 2、企业资质商户传入企业联系人电话
     */
    private String mblNo;
    /**
     * 经营类型
     * 取值范围：01 线下 02 线上 03 非盈利类 04 缴费类 05 保险类 06 私立院校
     */
    private String operationalType;
    /**
     * 资质类型
     * 取值范围：01 自然人 02 个体户 03 企业线上商户必须是 03 企业类型
     */
    private String haveLicenseNo;
    /**
     * 商户类型
     * 取值范围： 00 普通单店商户（非连锁商户）01 连锁总 02 连锁分 03 1+n 总 04 1+n 分
     * 说明：
     * （1）非连锁商户直接传入 00 即可。
     * （2）连锁总店、1+N 总店请传入 01、03，请勿当做普通商户进件。
     * （3）连锁总店、1+n 总店丌支持自然人进件
     * （4）1+n 分店丌支持企业资质商户。
     */
    private String mecTypeFlag;
    /**
     * 所属总店商户编号
     * 1、商户类型为 02，04 时必填
     * 2、商户类型是 02 连锁分店时，总店类型必须是01 连锁总店。
     * 3、商户类型是 04 1+n 分店时，总店类型必须是 03 1+n 总店。
     */
    private String parentMno;
    /**
     * 分店是否独立结算
     * 取值范围：00 是 01 否
     * 不传默认 00 独立结算
     * 说明：
     * 1、商户类型是 02（连锁分店） 时必传此参数.。
     * 2、其他情况传入无效，系统强制为 00 独立结算
     */
    private String independentModel;
    /**
     * 二维码费率（费率单位为%）
     * json 形式传入
     * 01 微信
     * 02 支付宝
     * 06 银联单笔小于等于 1000
     * 07 银联单笔大于 1000
     * 修改费率必须完整传入（同时包含微信、支付宝、银联二维码）
     * 例子：
     * "qrcodeList": [{"rate": "0.28","rateType": "01"},{"rate": "0.29","rateType": "02"},{"rate": "0.35","rateType": "06"},{"rate": "0.61","rateType": "07"}]
     */
    private ArrayList qrcodeList;
    /**
     * 结算类型
     * 取值范围：03：T1 | 04:D1
     * 不传入系统会根据合作机构签约时的默认结算产品执行，如需更改请联系对应商务经理
     * 例子 03
     */
    private String settleType;
    /**
     * 支持的支付渠道
     * 取值范围：01 支付宝 02 微信 03 银联二维码
     * 多选，逗号间隔，不传默认全部开通
     * "supportPayChannels":["01", "02"],
     */
    private String[] supportPayChannels;
    /**
     * 支持的交易类型
     * 取值范围：
     * 01 主扫 02 被扫 03 公众号/小程序/服务窗/银联JS 04 退货 05 APP
     * 多选，逗号间隔，不传默认全部开通
     */
    private String[] supportTradeTypes;
    /**
     * 微信活劢标识
     * 取值范围：01 微信智慧餐饮 02 高校食堂
     * 六省二市商户传入代表进件后直接报备到活动渠道号，后续才可以提交活劢报名申请。
     * 六省二市以外走随行付的商户传入无效，不直接向活动渠道号报备。
     */
    private String activityType;
    /**
     * 指定微信渠道号
     */
    private String specifyWechatChannel;
    /**
     * 指定支付宝PID
     */
    private String specifyALiPayChannel;
    /**
     * 线上产品类型
     * 线上类型商户必传
     * 取值范围：01 APP 02 网站 03 公众号
     */
    private String onlineType;
    /**
     * APP 名称/网站网址/公众号名称
     * 线上类型商户必传
     */
    private String onlineName;
    /**
     * APP 下载地址及账号信息
     */
    private String onlineTypeInfo;
    /**
     * 营业执照注册名称
     * 企业、个体户必传
     * 最大 122 个汉字，需确保和营业执照照片一致
     * 注意：如果个体户营业执照中没有注册名称或注
     * 册名称是***，此处需要按照“个体户+法人姓名”
     * 的格式传入，例如：个体户张三
     */
    private String cprRegNmCn;
    /**
     * 营业执照注册号
     * 企业、个体户必传
     * 营业执照号|统一信用编码最大 80 位数字
     */
    private String registCode;
    /**
     * 是否三证合一
     * 企业必传
     * 取值范围：00 是 01 否
     */
    private String licenseMatch;
    /**
     * 组织机构代码
     */
    private String orgCode;
    /**
     * 税务登记号
     */
    private String taxRegNo;
    /**
     * 营业执照起始日
     */
    private String businessLicStt;
    /**
     * 营业执照到期日
     */
    private String businessLicEnt;
    /**
     * 商户经营详细地址
     * 1、传入商户实际经营地信息
     * 2、详细地址无需填入省市区信息， 直接填写详细街道门牉号即可
     */
    private String cprRegAddr;
    /**
     * 商户经营地址省编码
     * 参见省市区代码表
     */
    private String regProvCd;
    /**
     * 商户经营地址市编码
     * 参见省市区代码表
     */
    private String regCityCd;
    /**
     * 商户经营地址区编码
     * 参见省市区代码表
     */
    private String regDistCd;
    /**
     * 经营类目
     * 参见类目 ID 附件
     * 注意：商户入网时请选择正确 MCC 入网。对于需要报名 AT 活劢（蓝海/微信智慧餐饮/微信高校食堂）的商户，请按照上游要求的 MCC 进件，
     * 否则会导致后期报名 AT 活劢失败。MCC 要求详见 AT 活劢报名接口文档。
     */
    private String mccCd;
    /**
     * 客服电话
     * 数字，不能有 -
     */
    private String csTelNo;
    /**
     * 法人/商户负责人
     */
    private String identityName;
    /**
     * 法人/商户负责人证件类型
     * 00 身份证 写死
     */
    private String identityTyp;
    /**
     * 法人/商户负责人证件号
     */
    private String identityNo;
    /**
     * 法人/商户负责人证件起始日
     */
    private String legalPersonLicStt;
    /**
     * 法人/商户负责人证件到期日
     */
    private String legalPersonLicEnt;
    /**
     * 结算账户名
     * 说明：
     * 1、对公结算时账户名需不注册名一致；
     * 2、自然人商户、线上类商户丌允许授权结算
     */
    private String actNm;
    /**
     * 结算账户类型
     * 自然人商户只允许对私结算
     * 线上商户只允许对公结算
     * 取值范围：00 对公 01 对私
     */
    private String actTyp;
    /**
     * 结算人证件号
     * 对私结算必传
     */
    private String stmManIdNo;
    /**
     * 结算人证件号起始日
     */
    private String accountLicStt;
    /**
     * 结算人证件号到期日
     */
    private String accountLicEnt;
    /**
     * 结算卡号
     */
    private String actNo;
    /**
     * 开户支行联行行号
     */
    private String lbnkNo;
    /**
     * 开户支行名称
     */
    private String lbnkNm;
    /**
     * 营业执照照片
     * 企业、个体户必传
     */
    private String licensePic;
    /**
     * 税务登记证照片
     * 企业非三证合一必传
     */
    private String taxRegistLicensePic;
    /**
     * 组织机构代码证
     * 企业非三证合一必传
     */
    private String orgCodePic;
    /**
     * 法人/商户负责人身份证正面（人像面）
     */
    private String legalPersonidPositivePic;
    /**
     * 法人/商户负责人身份证反面（国徽面）
     */
    private String legalPersonidOppositePic;
    /**
     * 开户许可证
     * 对公结算必传
     */
    private String openingAccountLicensePic;
    /**
     * 银行卡正面
     * 对私结算必传
     */
    private String bankCardPositivePic;
    /**
     * 银行卡反面
     */
    private String bankCardOppositePic;
    /**
     * 结算人身份证反面（国徽面）
     * 对私授权结算必传
     * 1、对私结算必传账户人身份证
     * 2、连锁分店统一结算的情况可丌传
     */
    private String settlePersonIdcardOpposite;
    /**
     * 结算人身份证正面（人像面）
     * 对私授权结算必传
     * 1、对私结算必传账户人身份证
     * 2、连锁分店统一结算的情况可丌传。
     */
    private String settlePersonIdcardPositive;
    /**
     * 商户协议照片
     */
    private String merchantAgreementPic;
    /**
     * 门头照片
     */
    private String storePic;
    /**
     * 真实商户内景图片
     */
    private String insideScenePic;
    /**
     * 经营场所-含收银台
     */
    private String businessPlacePic;
    /**
     * ICP 许可证或公众号主体信息截图
     * 线上网站类、公众号类商户必传
     */
    private String icpLicence;
    /**
     * 手持身份证（人像面）照片
     */
    private String handIdcardPic;
    /**
     * 租赁协议三(签章页)
     */
    private String leaseAgreementThreePic;
    /**
     * 租赁协议二(面积、有效期页)
     */
    private String leaseAgreementTwoPic;
    /**
     * 租赁协议一(封面)
     */
    private String leaseAgreementOnePic;
    /**
     * 其他资料照片 1
     */
    private String otherMaterialPictureOne;
    /**
     * 其他资料照片 2
     */
    private String otherMaterialPictureTwo;
    /**
     * 其他资料照 3
     */
    private String otherMaterialPictureThree;
    /**
     * 其他资料照片 4
     */
    private String otherMaterialPictureFour;
    /**
     * 其他资料照 5
     */
    private String otherMaterialPictureFive;
    /**
     * 代理人签名
     */
    private String agentPersonSignature;
    /**
     * 确认人签名
     */
    private String confirmPersonSignature;
    /**
     * 非法人结算授权函（授权结算必传）
     * 非法人对私结算，即结算账户类型为对私结算，
     * 且结算人身份证号不法人身份证号丌一致时必传
     */
    private String letterOfAuthPic;
    /**
     * 统一结算无营业执照说明
     * 个人资质的连锁分店如果统一结算，需上传总店
     * 对该店情况说明，证明连锁关系
     */
    private String unionSettleWithoutLicense;
    /**
     * 社会团体法人证书
     */
    private String societyGroupLegPerPic;
    /**
     * 基金会法人登记证书
     */
    private String foundationLegPerRegPic;
    /**
     * 办学许可证
     */
    private String schoolLicese;
    /**
     * 医疗结构办学许可证
     */
    private String medicalInstitutionLicense;
    /**
     * 经营保险业务许可证
     */
    private String insuranceLicese;
    /**
     * 保险业务法人等级证书
     */
    private String insuranceLegPerGradePic;
    /**
     * 民办教育许可证
     */
    private String privateEducationLicense;
    /**
     * 收费证明文件
     */
    private String chargeProofPic;
    /**
     * 是否校验结算人三要素
     * 取值范围：00 校验 01不校验(默认为01)
     */
    private String settlementAuthen = "01";

    @Override
    public Class<MerchantIncomeEditResponse> getResponseClass() {
        return MerchantIncomeEditResponse.class;
    }
}