/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.merchant;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.merchant.MerchantChangeQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户变更查询
 *
 * @author buhao
 * @version MerchantChangeQueryRequest.java, v 0.1 2020-06-08 11:25 buhao
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantChangeQueryRequest extends VbillBizRequest<MerchantChangeQueryResponse> {

    /**
     * 进件申请 ID
     */
    @NotBlank(message = "申请ID不能为空")
    @Length(max = 32, message = "申请ID超长")
    private String applicationId;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantChangeQueryResponse> getResponseClass() {
        return MerchantChangeQueryResponse.class;
    }
}