/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.client;

import com.fshows.vbill.sdk.exception.VbillApiException;
import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.BaseVbillResponse;
import com.fshows.vbill.sdk.response.VbillBizResponse;

/**
 * 随行付开放平台接口请求客户端
 *
 * @author wujn
 * @version VbillClient.java, v 0.1 2020-04-23 5:27 PM wujn
 */
public interface VbillClient {


    /**
     * 请求随行付openapi接口
     *
     * @param serverUrl    请求地址
     * @param request      请求参数
     * @param orgId        orgId
     * @param reqId        reqId
     * @param version      版本
     * @param isSign       是否加签
     * @param isVerifySign 是否验签
     * @param timeout      超时时间
     * @param <T>          返回值泛型
     * @return
     * @throws VbillApiException
     */
    <T extends VbillBizResponse> BaseVbillResponse<T> execute(String serverUrl,
                                                              VbillBizRequest<T> request,
                                                              String orgId, String reqId,
                                                              String version,
                                                              boolean isSign,
                                                              boolean isVerifySign,
                                                              Integer timeout) throws VbillApiException;

    /**
     * 请求随行付openapi接口
     *
     * @param serverUrl 请求地址
     * @param request   请求参数
     * @param orgId     orgId
     * @param reqId     请求ID
     * @param <T>       返回值泛型
     * @return
     * @throws VbillApiException
     */
    <T extends VbillBizResponse> BaseVbillResponse<T> execute(String serverUrl, VbillBizRequest<T> request, String orgId, String reqId) throws VbillApiException;
}
