/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.TradeTotalResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version TradeTotalParam.java, v 0.1 2020-04-26 15:50
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TradeTotalRequest extends VbillBizRequest<TradeTotalResponse> {

    private static final long serialVersionUID = 5187674667587111636L;
    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 账单日期yyyyMMdd
     * 查询区间为当天到前30天
     */
    @NotBlank
    private String billTime;

    @Override
    public Class<TradeTotalResponse> getResponseClass() {
        return TradeTotalResponse.class;
    }
}