/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.client;

import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.vbill.sdk.exception.VbillApiException;
import com.fshows.vbill.sdk.request.common.UploadPictureRequest;
import com.fshows.vbill.sdk.response.BaseVbillResponse;
import com.fshows.vbill.sdk.response.common.UploadPictureReponse;
import com.fshows.vbill.sdk.util.ReqIdUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.net.URI;

/**
 * @author wujn
 * @version UploadPictureClient.java, v 0.1 2020-04-27 10:29 AM wujn
 */
@Slf4j
public class UploadPictureClient {

    /**
     * 发起图片上传请求
     *
     * @param request
     * @return
     * @throws VbillApiException
     */
    @SuppressWarnings("unchecked")
    public BaseVbillResponse upload(UploadPictureRequest request) throws VbillApiException {
        long beginTime = System.currentTimeMillis();
        log.info("【vbill-sdk】请求开始 reqId={},url={},request={},begin={}", request.getReqId(), request.getUploadUrl(), request, beginTime);
        String uploadUrl = request.getUploadUrl();
        String downloadUrl = request.getDownloadUrl();
        if (StringUtils.isBlank(uploadUrl) || StringUtils.isBlank(downloadUrl)) {
            throw new IllegalArgumentException("上传和下载地址都不能为空");
        }
        try {
            String filePath = new URI(downloadUrl).getPath();
            String fileSuffix = StringUtils.substring(filePath, filePath.lastIndexOf("."));
            if (".jpeg".equalsIgnoreCase(fileSuffix)) {
                fileSuffix = ".jpg";
            }
            String fileName = ReqIdUtil.getId() + fileSuffix;
            HttpResponse httpResponse = HttpRequest.get(downloadUrl).executeAsync();
            if (!httpResponse.isOk()) {
                throw new HttpException("Server response error with status code: [{}]", httpResponse.getStatus());
            }
            //30s超时
            Integer timeout = (request.getTimeout() == null || request.getTimeout() <= 0) ? 30 * 1000 : request.getTimeout();
            String responseStr = HttpUtil.createPost(uploadUrl).form("file", httpResponse.bodyBytes(), fileName)
                    .form("reqId", request.getReqId())
                    .form("orgId", request.getOrgId())
                    .form("pictureType", request.getPictureType()).timeout(timeout).execute().body();
            JSONObject jsonObject = JSON.parseObject(responseStr);
            BaseVbillResponse response = new BaseVbillResponse<>();
            response.setReqId(jsonObject.getString("reqId"));
            response.setMsg(jsonObject.getString("msg"));
            response.setCode(jsonObject.getString("code"));
            response.setOrgId(jsonObject.getString("orgId"));
            UploadPictureReponse respData = JSON.parseObject(jsonObject.getString("respData"), UploadPictureReponse.class);
            response.setRespData(respData);
            log.info("【vbill-sdk】请求结束 reqId={},url={},request={},response={},cost={} ms", request.getReqId(), uploadUrl, request, response, System.currentTimeMillis() - beginTime);
            return response;
        } catch (Exception ex) {
            throw new VbillApiException(ex.getMessage(), ex);
        }
    }

}
