/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.other;

import lombok.Data;

/**
 * @author yangdw
 * @version TradePageDetailResponse.java, v 0.1 2020-04-29 10:46
 */
@Data
public class TradePageDetailResponse {

    /**
     * 商户订单号
     */
    private String oraNo;
    /**
     * 随行付订单号
     */
    private String uuid;
    /**
     * 落单号，供退款和退款查询使用
     */
    private String sxfUuid;
    /**
     * 交易完成时间
     */
    private String payTime;
    /**
     * 交易时间
     */
    private String tranTime;
    /**
     * 交易金额
     */
    private String oriTranAmt;
    /**
     * 消费者付款金额
     */
    private String totalOffstAmt;
    /**
     * 是否做分账分账交易使用;00:做; 01:不做;不传默认为不做分账
     */
    private String ledgerAccountFlag;
    /**
     * 是否已做分账 00:是，01:否
     */
    private String ledgerAccountStatus;
    /**
     * 银联对账 key
     */
    private String reconKey;
    /**
     * 支付渠道对订单的描述，取值范围 : WECHAT: 微信,ALIPAY: 支付宝 ,UNIONPAY: 银联
     */
    private String payType;
    /**
     * 支付方式
     * 00 主扫, 01 被扫, 02 公众号/服务窗, 03 小程序, 04 app
     */
    private String payWay;
    /**
     * 付款银行，例 如 ICBC
     */
    private String payBank;
    /**
     * 商户店铺名称
     */
    private String storeName;
    /**
     * 订单标题
     */
    private String subject;
    /**
     * 备用
     */
    private String extend;
    /**
     * 消费者用户标识
     * 微信是 subopenid
     * 支付宝是 userId
     */
    private String buyerId;
    /**
     * 交易状态
     */
    private String tranSts;

}   