/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.account;

import lombok.Data;

/**
 * @author yangdw
 * @version SettleInfoModel.java, v 0.1 2020-04-27 21:19
 */
@Data
public class SettleInfoResponse {

    /**
     * 机构号
     */
    private String orgId;

    /**
     * 商编
     */
    private String mno;

    /**
     * 结算流水
     */
    private String serialNo;

    /**
     * 结算金额
     */
    private String amount;

    /**
     * 结算状态
     * S:付款成功
     * F:付款失败
     * P:付款中
     */
    private String settleStatus;

    /**
     * 具体结算状态
     * 00:初始化
     * 01:结算失败
     * 02：待付款
     * 03:已撤销
     * 04：延迟付款
     * 05:扣款失败
     * 06:付款中
     * 07:付款失败
     * 08:付款成功
     * 09:审批撤销失败
     * 10：银行退票成功
     */
    private String settleSts;

    /**
     * 手续费
     */
    private String fee;

    /**
     * 结算账户类型
     */
    private String settleAccountType;

    /**
     * 结算账户名 加密
     */
    private String settleAccountNm;

    /**
     * 结算账户号 加密
     */
    private String settleBnkNo;

    /**
     * 结算银行
     */
    private String settleBankNm;

    /**
     * 结算支行
     */
    private String settleLbnk;

    /**
     * 结算时间
     */
    private String settleDt;

    /**
     * 结算完成时间
     */
    private String settleTime;

    /**
     * 结算失败原因
     * 结算状态为 F 时返回
     */
    private String refReason;

    /**
     * 提现单号
     */
    private String orderNo;

}   