/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.payment.VbillRefundQueryResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Liluqing
 * @version RefundQueryParam.java, v 0.1 2020-04-23 20:20
 */
@Data
public class VbillRefundQueryRequest extends VbillBizRequest<VbillRefundQueryResponse> implements Serializable {

    /**
     * 随行付商编
     */
    private String mno;

    /**
     * 商户订单号
     */
    private String ordNo;

    /**
     * 科技公司订单号
     */
    private String uuid;

    @Override
    public Class<VbillRefundQueryResponse> getResponseClass() {
        return VbillRefundQueryResponse.class;
    }
}