/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.other;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.other.LedgerPermissionResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author yangdw
 * @version LedgerPermissionParam.java, v 0.1 2020-04-22 18:41
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LedgerPermissionRequest extends VbillBizRequest<LedgerPermissionResponse> {

    private static final long serialVersionUID = 9041610546740756393L;

    /**
     * 分账也商编主体
     */
    @NotBlank
    private String mno;

    /**
     * 可分账商编号码,逗号隔开
     */
    @NotBlank
    @Length(max = 500)
    private String mnoArray;

    @Override
    public Class<LedgerPermissionResponse> getResponseClass() {
        return LedgerPermissionResponse.class;
    }
}