/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.account;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.account.CapitalCashWithdrawResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 提现接口
 *
 * @author wangyi
 * @version CapitalCashWithdrawRequest.java, v 0.1 2020-12-28 6:29 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CapitalCashWithdrawRequest extends VbillBizRequest<CapitalCashWithdrawResponse> {

    private static final long serialVersionUID = 3824540673331298032L;

    /**
     * 商户订单号
     */
    @NotBlank
    private String ordNo;

    /**
     * 商编
     */
    @NotBlank
    private String mno;

    /**
     * 到账类型
     * 00：即时到账；01：T1日到账
     */
    @NotBlank
    private String withdrawType;

    /**
     * 提现金额
     * 单位元；保留两位小数
     */
    @NotBlank
    private String amt;

    @Override
    public Class<CapitalCashWithdrawResponse> getResponseClass() {
        return CapitalCashWithdrawResponse.class;
    }
}
