/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.enums;

/**
 *
 * @author Liluqing
 * @version VbillBaseApi.java, v 0.1 2020-06-08 11:49
 */
public interface VbillBaseApi {

    /**
     * 获取url资源子路径
     * 例如: 接口的URL是 “https://openapi-test.tianquetech.com/order/reverseScan”
     * ,则ApiSubPath就是“/order/reverseScan”
     */
    String getApiSubPath();

    /**
     * 获取API URL地址
     *
     * @param basePath 基础域名,例如“https://openapi-test.tianquetech.com”
     * @return 返回完成的API URL, 例如“https://openapi-test.tianquetech.com/order/reverseScan”
     */
    String getApiURL(String basePath);
}