/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.umpay.sdk.response.trade.pay.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 支付宝本交易支付时使用的所有优惠券信息详见&lt;支付宝官方文档&gt;
 *
 * @author liluqing
 * @version UmpayAlipayVoucherDetailResponse.java, v 0.1 2022-03-16 12:09
 */
@Data
public class UmpayAlipayVoucherDetailResponse implements Serializable {

    private static final long serialVersionUID = -2213838555773263013L;

    /**
     * 券 id
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "id长度不能超过32")
    private String id;

    /**
     * 券名称
     * <p>
     * (选填)
     */
    @Length(max = 64, message = "name长度不能超过64")
    private String name;

    /**
     * 当 前 有 三 种 类 型 ：ALIPAY_FIX_VOUCHER - 全场代金券 ALIPAY_DISCOUNT_VOUCH ER折扣券 ALIPAY_ITEM_VOUCHER单品优惠 注：不排除将来新增其他类型 的可能，商家接入时注意兼容性避免硬编码
     * <p>
     * (选填)
     */
    @Length(max = 32, message = "type长度不能超过32")
    private String type;

    /**
     * 优惠券面额，它应该会等于商家出资加上其他出资方出资
     * <p>
     * (选填)
     */
    private BigDecimal amount;

    /**
     * 商家出资（特指发起交易的商家出资金额）
     * <p>
     * (选填)
     */
    private BigDecimal merchantContribute;

    /**
     * 其他出资方出资金额，可能是支付宝，可能是品牌商，或者其他方，也可能是他们的一起出资
     * <p>
     * (选填)
     */
    private BigDecimal otherContribute;

    /**
     * 优惠券备注信息
     * <p>
     * (选填)
     */
    @Length(max = 256, message = "memo长度不能超过256")
    private String memo;

    /**
     * 券模板 id
     * <p>
     * (选填)
     */
    @Length(max = 64, message = "templateId长度不能超过64")
    private String templateId;

    /**
     * 支付宝优惠券的其他出资方明细
     * <p>
     * (特殊必填)
     */
    private List<UmpayOtherContributeDetailResponse> alipayOtherContributeDetail;

    /**
     * 如果使用的这张券是用户购买的，则该字段代表用户在购买这张券时用户实际付款的金额
     * <p>
     * (选填)
     */
    private BigDecimal purchaseBuyerContribute;

    /**
     * 如果使用的这张券是用户购买的，则该字段代表用户在购买这张券时商户优惠的金额
     * <p>
     * (选填)
     */
    private BigDecimal purchaseMerchantContribute;

    /**
     * 如果使用的这张券是用户购买的，则该字段代表用户在购买这张券时平台优惠的金额
     * <p>
     * (选填)
     */
    private BigDecimal purchaseAntContribute;
}