/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.trade.order;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 手续费补贴金上传
 *
 * @author
 * @version UmpayFeeSubsidyUploadResponse.java, v 0.1 2022-03-16 16:20:42
 */
@Data
public class UmpayFeeSubsidyUploadResponse implements Serializable {

    private static final long serialVersionUID = -2213838555346338544L;


    /**
     * 聚合收单平台为商户分配的唯一&nbsp;ID,商户入驻后由平台返回；
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在系统中唯一；
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "merchantId长度不能超过32")
    private String merchantId;

    /**
     * 服务商订单号，当send_type in （1，2）时必返
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 聚合收单平台的订单号，当send_type in （1，2）时必返
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    /**
     * 上传类型：1-上传手续费&amp;补贴金；2-上传补贴金
     *
     * (必填)
     */
    @NotNull
    private Integer sendType;

    /**
     * 手续费，单位：元，保留两位小数当send_type=1时返回
     *
     * (特殊必填)
     */
    private BigDecimal merchantFee;

    /**
     * 补贴金，单位：元，保留两位小数
     *
     * (必填)
     */
    @NotNull
    private BigDecimal subsidyFee;

}