/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.merchant;

import com.fshows.umpay.sdk.response.merchant.item.MerchantRateItemResponse;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author
 * @version UmpayAggregationStoreRateQueryResponse.java, v 0.1 2022-03-16 15:28:37
 */
@Data
public class UmpayAggregationStoreRateQueryResponse implements Serializable {

    private static final long serialVersionUID = -4290791134488800466L;

    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在服务商系统中唯一
     * <p>
     * (必填)
     */
    private String externalId;

    /**
     * 商户终端费率集合，精确到小数点后5位
     * <p>
     * (必填)
     */
    private List<MerchantRateItemResponse> merchantRates;

}