/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.merchant;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fshows.umpay.sdk.response.merchant.item.MerchantRateItemResponse;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author youmingming
 * @version AggregationMerchantEnterResponse.java, v 0.1 2022-02-09 下午5:18 youmingming
 */
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@Data
public class AggregationMerchantEnterResponse implements Serializable {

    private static final long serialVersionUID = -2160372780270552031L;

    /**
     * 聚合收单平台为商户分配的唯一ID
     */
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在系统中唯一
     */
    private String merchantId;

    /**
     * 商户状态
     * 1-入驻成功；3-入驻失败；4-待审核，审核结果通过<商户审核回调>返回
     */
    private Integer status;

    /**
     * 商户入驻的结果
     */
    private String msg;

    /**
     * 当前渠道下对应的支付宝子商户号，入驻成功且开通支付宝交易功能成功后返回
     */
    private String alipayId;

    /**
     * 当前渠道下对应的微信子商户号，入驻成功且开通微信交易功能成功后返回
     */
    private String subMchId;

    /**
     * 当前渠道下对应的云闪付子商户号，入驻成功且开通云闪付交易功能成功后返回
     */
    private String unionId;

    /**
     * 中行数币子商户号
     * 入驻成功且开通数币交易功能成功后返回，须子商户号及子钱包开通后才能交易
     */
    private String bocEcnyId;

    /**
     * 中行数币开通状态
     * 0-审核中 1-商户开立成功 2-商户开立失败
     */
    private String bocEcnyState;

    /**
     * 支付宝交易功能开通失败原因
     */
    private String aliMsg;

    /**
     * 微信交易功能开通失败原因
     */
    private String wxMsg;

    /**
     * 中行数币开通失败原因
     */
    private String bocEcnyMsg;


    /**
     * 商户费率集合
     */
    private List<MerchantRateItemResponse> merchantRateList;

}