/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved
 */
package com.fshows.umpay.sdk.response.fund.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author liubo
 * @version UmpayAccountInvestQueryItemResponse.java, v 0.1 2023-05-15-10:50 上午 liubo
 */
@Data
public class UmpayAccountInvestQueryItemResponse implements Serializable {

    private static final long serialVersionUID = 4313858559087802900L;

    /**
     * 充值流水号
     */
    @NotNull
    @Length(max = 64, message = "充值流水号长度不能超过64")
    String investRecdId;

    /**
     * 账号id
     */
    @Length(max = 20, message = "账户id长度不能超过20")
    String accountId;

    /**
     * 充值日期
     */
    @NotNull
    @Length(max = 8, message = "充值日期长度不能超过8")
    String investDate;

    /**
     * 充值金额
     */
    BigDecimal investAmount;

}