/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved
 */
package com.fshows.umpay.sdk.response.fund.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 账户余额列表，服务商其他账户列表
 * @author liubo
 * @version UmpayAccountBalanceQueryItemResponse.java, v 0.1 2023-05-15-10:20 上午 liubo
 */
@Data
public class UmpayAccountBalanceQueryItemResponse implements Serializable {

    private static final long serialVersionUID = 7413098635959461280L;

    /**
     * 账户ID
     */
    @Length(max = 20, message = "accountId长度不能超过20")
    String accountId;

    /**
     *  账户余额
     */
    BigDecimal accountAmount;


}