/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.fund;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 发起提现申请
 *
 * @author
 * @version UmpayDrawApplyResponse.java, v 0.1 2022-03-16 16:36:39
 */
@Data
public class UmpayDrawApplyResponse implements Serializable {

    private static final long serialVersionUID = -2213838555322541598L;


    /**
     * 提现状态：0-提现中；1-提现成功；2-提现失败
     *
     * (必填)
     */
    @NotNull
    private Integer drawStatus;

    /**
     * 返回信息，提现失败返回
     *
     * (选填)
     */
    @Length(max = 255, message = "resMsg长度不能超过255")
    private String resMsg;

    /**
     * 服务商的提现单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outDrawNo长度不能超过64")
    private String outDrawNo;

    /**
     * 聚合收单平台提现单号（根据此单号回调提现结果）
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "drawOrderSn长度不能超过64")
    private String drawOrderSn;

}