/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved
 */
package com.fshows.umpay.sdk.response.fund;

import com.fshows.umpay.sdk.response.fund.item.UmpayAccountBalanceQueryItemResponse;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 服务商余额查询返回数据
 * @author liubo
 * @version UmpayAccountBalanceQueryResponse.java, v 0.1 2023-05-15-9:49 上午 liubo
 */
@Data
public class UmpayAccountBalanceQueryResponse implements Serializable {

    private static final long serialVersionUID = 2413898455959429285L;
    /**
     *  账户类型：1-补贴账户
     */
    @NotNull
    Integer accountType;

    /**
     *  账户余额，服务商自带账户余额
     */
    BigDecimal amount;

    /**
     *  账户余额列表，服务商其他账户列表
     */
    List<UmpayAccountBalanceQueryItemResponse> accountList;

}