/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.coupon;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 解冻退回
 *
 * @author
 * @version UmpayWriteOffReturnResponse.java, v 0.1 2023-01-31 09:56:55
 */
@Data
public class UmpayWriteOffReturnResponse implements Serializable {

    private static final long serialVersionUID = -2213838555501018121L;


    /**
     * 聚合收单平台为商户分配的惟一 ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商解冻退回单号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outReturnNo长度不能超过64")
    private String outReturnNo;

    /**
     * 聚合收单平台解冻退回单号，在系统内唯一
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "returnNo长度不能超过32")
    private String returnNo;

    /**
     * 服务商解冻单号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outWriteoffNo长度不能超过64")
    private String outWriteoffNo;

    /**
     * 聚合收单平台解冻单号，在系统内唯一
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "writeoffNo长度不能超过32")
    private String writeoffNo;

    /**
     * 解冻退回状态0-解冻退回中；1-解冻退回成功；2-解冻退回失败
     * <p>
     * (必填)
     */
    @NotNull
    private Integer returnStatus;

    /**
     * 解冻退回金额，单位：元，精确到小数点后两位，取值范围[0.01,100000000]
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal amount;

    /**
     * 解冻退回净额
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal netMoney;

    /**
     * 补贴金额，单位元
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal subsidyFee;

    /**
     * 解冻退回完成时间，成功时返回格式为yyyy-MM-ddHH:mm:ss，如2009年12月25日9点10分10秒表示为2009-12-2509:10:10
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "returnClose长度不能超过32")
    private String returnClose;

    /**
     * 剩余可解冻交易金额
     * <p>
     * (特殊必填)
     */
    private BigDecimal restRealMoney;

    /**
     * 剩余可解冻补贴金
     * <p>
     * (特殊必填)
     */
    private BigDecimal restSubsidyFee;

}