package com.fshows.umpay.sdk.request.trade.pay.item;/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author shijp
 * @version UmpayPromotionDetailRequest.java, v0.1 2022-11-10-4:17 下午 shijp
 */
@Data
public class UmpayPromotionDetailRequest implements Serializable {
    private static final long serialVersionUID = -8035659833334429164L;

    /**
    * 优惠券ID
    */
    @NotBlank
    @Length(max = 32,message = "promotionId长度不能超过32")
    private String promotionId;

    /**
    * 优惠券名称
    */
    @NotBlank
    @Length(max = 32,message = "优惠券name长度不能超过128")
    private String name;

    /**
     * 优惠券类型：1- 代金券，需要走结算资金的充值型代金券（预充券）
     */
    @NotNull(message = "优惠券类型不能为空")
    private Integer type;

    /**
     * 优惠券面额，单位为元，精确到小数点后两位，取值范围[0.01,100000000]
     */
    @Digits(integer =9, fraction = 2,message = "amount格式不正确")
    @DecimalMax(value = "100000000",message = "amount格式不正确")
    @DecimalMin(value = "0.01",message = "amount格式不正确")
    @NotNull(message = "优惠券面额amount不能为空")
    private BigDecimal amount;
}
