/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.merchant;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.merchant.UmpaySubmerchantBankBindResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 商户结算信息变更(万达商户专用接口)
 *
 * @author
 * @version UmpaySubmerchantAccountBindNewRequest.java, v 0.1 2022-12-06 18:14:02
 */
@Data
public class UmpaySubmerchantAccountBindNewRequest extends UmBizRequest<UmpaySubmerchantBankBindResponse> {

    private static final long serialVersionUID = 5579006655843474172L;
    /**
     * 聚合收单平台为商户分配的唯一ID,商户入驻后由平台返回
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 结算银行卡卡号
     * <p>
     * (必填)
     */
    @Length(max = 30, message = "bankCardNo长度不能超过30")
    private String bankCardNo;

    /**
     * 结算银行卡开户名，开户名不允许修改，需与入驻平台时的持卡人姓名保持一致
     * <p>
     * (必填)
     */
//    @Length(max = 10, message = "cardHolder长度不能超过10")
    private String cardHolder;

    /**
     * 账户类型：1-对公；0-对私
     * <p>
     * (必填)
     */
    @NotNull
    private Integer isPublicAccount;

    /**
     * 结算卡开户行
     * <p>
     * (必填)
     */
    @Length(max = 60, message = "openBank长度不能超过60")
    private String openBank;

    /**
     * 开户支行联行号（账户类型为1-对公时必填）
     * <p>
     * (特殊必填)
     */
    @Length(max = 20, message = "unitedBankNo长度不能超过20")
    private String unitedBankNo;

    /**
     * 结算卡类型：1-法人； 0-非法人； 2-企业
     * <p>
     * (必填)
     */
    @NotNull
    private Integer cardType;

    /**
     * 结算人身份证号
     */
    private String bankIdCardNum;

    /**
     * 结算人证件类型 (账户类型为对公时不填写)
     * 01身份证
     * 03护照
     * 04香港居民来往内地通行证(回乡证)
     * 05台湾同胞来往内地通行证（台胞证)
     * 09临时身份证
     * 10外国人居留证
     * 11澳门居民来往内地通行证（回乡证）
     * 12港澳居民证
     * 13台湾居民证
     */
    private String bankIdCardType;

    @Override
    public Class<UmpaySubmerchantBankBindResponse> getResponseClass() {
        return UmpaySubmerchantBankBindResponse.class;
    }
}