/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved
 */
package com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpayAccountInvestQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * @author liubo
 * @version UmpayAccountInvestQueryRequest.java, v 0.1 2023-05-15-10:42 上午 liubo
 */
@Data
public class UmpayAccountInvestQueryRequest extends UmBizRequest<UmpayAccountInvestQueryResponse> {

    private static final long serialVersionUID = 7613838329738098178L;
    /**
     * 账户类型：1-补贴账户
     */
    @NotNull
    Integer accountType;

    /**
     * 账户ID
     */
    @Length(max = 20, message = "accountId长度不能超过20")
    String accountId;


    /**
     * 充值日期，格式为：yyyyMMdd示例:20201218
     *
     */
    @Length(max = 8, message = "investDate长度不能超过8")
    private String investDate;

    @Override
    public Class<UmpayAccountInvestQueryResponse> getResponseClass() {
        return UmpayAccountInvestQueryResponse.class;
    }
}