/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved
 */
package com.fshows.umpay.sdk.request.fund;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.fund.UmpayAccountBalanceQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * @author liubo
 * @version UmpayAccountBalanceQueryRequest.java, v 0.1 2023-05-15-9:49 上午 liubo
 */
@Data
public class UmpayAccountBalanceQueryRequest extends UmBizRequest<UmpayAccountBalanceQueryResponse> {

    private static final long serialVersionUID = 6298529998747863915L;
    /**
     * 账户类型：1-补贴账户
     */
    @NotNull
    Integer accountType;

    /**
     * 账户ID
     */
    @Length(max = 20, message = "accountId长度不能超过20")
    String accountId;

    @Override
    public Class<UmpayAccountBalanceQueryResponse> getResponseClass() {
        return UmpayAccountBalanceQueryResponse.class;
    }
}