/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.activity;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.activity.UmpayAlipayActivityQueryResponse;
import lombok.Data;

/**
 * 支付宝活动审核状态查询接口
 *
 * @author
 * @version UmpayAlipayActivityQueryRequest.java, v 0.1 2022-03-16 16:47:19
 */
@Data
public class UmpayAlipayActivityQueryRequest extends UmBizRequest<UmpayAlipayActivityQueryResponse> {

    private static final long serialVersionUID = -2213838555544640218L;


    /**
     * 聚合收单平台为商户分配的唯一 ID,商户入驻后由平台返回；
     * store_id和merchant_id二选一必填；
     *
     * (选填)
     */
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在系统中唯一；
     * store_id和merchant_id二选一必填
     *
     * (选填)
     */
    private String merchantId;

    /**
     * 支付宝子商户号（一个商户含多个子商户号的情况下必填）
     *
     * (选填)
     */
    private String alipayId;

    @Override
    public Class<UmpayAlipayActivityQueryResponse> getResponseClass() {
        return UmpayAlipayActivityQueryResponse.class;
    }
}