/**
 * Copyright (c) 2003, 2018, UMF and/or its affiliates. All rights reserved.
 */
package com.fshows.umpay.sdk.request;

import com.umpay.dto.UMFResponse.Message;
import com.umpay.dto.UMFResponse.Message.Link;
import com.umpay.mer.ConfigContext;

import java.util.List;

/**
 <p>Title:MerchantBaseRequest</p>
 <p>Description: 请求响应基类</p>
 */
public class MerchantBaseRequest {

	// 生产地址
    public static final String baseUrl = "http://b2b.umfintech.com/merAccess";
    // 联调地址
    //public static final String baseUrl = "http://111.205.18.100:63948/merAccess";
    public String version = "1.0";
    public String mer_id;

	public String ret_code;

	public String ret_msg;

	public List<Link> links;

	public MerchantBaseRequest doRequest() throws Exception {
		return null;
	}

	public MerchantBaseRequest convertResult(Message<? extends MerchantBaseRequest> message, Class<? extends MerchantBaseRequest> clazz) {
		if (message == null) {
			return null;
		} else if (message.getData() != null) {
			message.getData().setRet_code(message.getMeta().getRet_code());
			message.getData().setRet_msg(message.getMeta().getRet_msg());
			message.getData().setLinks(message.getLinks());
		} else {
			ret_code = message.getMeta().getRet_code();
			ret_msg = message.getMeta().getRet_msg();
			links = message.getLinks();
		}
		if (message.getData() == null) {
			return this;
		} else {
			return message.getData();
		}
	}

	public ConfigContext createAPIContext() throws Exception {
		ConfigContext apiContext = new ConfigContext(getRequestUrl(), mer_id);
		return apiContext;
	}

	public String getRequestUrl() {
		return baseUrl;
	}

	public String getRet_code() {
		return ret_code;
	}

	public void setRet_code(String ret_code) {
		this.ret_code = ret_code;
	}

	public String getRet_msg() {
		return ret_msg;
	}

	public void setRet_msg(String ret_msg) {
		this.ret_msg = ret_msg;
	}

	public String getMer_id() {
		return mer_id;
	}

	public void setMer_id(String mer_id) {
		this.mer_id = mer_id;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public List<Link> getLinks() {
		return links;
	}

	public void setLinks(List<Link> links) {
		this.links = links;
	}

	@Override
	public String toString() {
		return "MerchantBaseRequest{" +
				"version='" + version + '\'' +
				", mer_id='" + mer_id + '\'' +
				", ret_code='" + ret_code + '\'' +
				", ret_msg='" + ret_msg + '\'' +
				", links=" + links +
				'}';
	}
}
