/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.prepaycard.UmpayPrepayCardActivationRequest;
import com.fshows.umpay.sdk.request.prepaycard.UmpayPrepayCardBalanceQueryRequest;
import com.fshows.umpay.sdk.response.prepaycard.UmpayPrepayCardActivationResponse;
import com.fshows.umpay.sdk.response.prepaycard.UmpayPrepayCardBalanceQueryResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * 预付卡相关API枚举
 *
 * @author linzy
 * @version UmPrepayCardApiEnum.java, v 0.1 2022-07-25 下午10:41 linzy
 */
public enum UmPrepayCardApiEnum implements UmpayApiDefinition {
    //预付卡相关API枚举
    PREPAY_CARD_ACTIVATION(
            "预付卡激活",
            "aggregation.prepay.card.activation",
            UmpayPrepayCardActivationRequest.class,
            UmpayPrepayCardActivationResponse.class
    ),
    PREPAY_CARD_BALANCE_QUERY(
            "预付卡余额查询",
            "aggregation.prepay.card.balance.query",
            UmpayPrepayCardBalanceQueryRequest.class,
            UmpayPrepayCardBalanceQueryResponse.class
    ),

    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmPrepayCardApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmPrepayCardApiEnum getByValue(String value) {
        UmPrepayCardApiEnum[] valueList = UmPrepayCardApiEnum.values();
        for (UmPrepayCardApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}